/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.data.MiniTableRenderData;
import com.deepoove.poi.data.NumbericRenderData;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.policy.MiniTableRenderPolicy;
import com.deepoove.poi.policy.NumbericRenderPolicy;
import com.deepoove.poi.policy.PictureRenderPolicy;
import com.deepoove.poi.policy.TextRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.util.StyleUtils;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class ListRenderPolicy
extends AbstractRenderPolicy<List<Object>> {
    @Override
    protected boolean validate(List<Object> data) {
        return null != data && !data.isEmpty();
    }

    @Override
    public void doRender(RenderContext<List<Object>> context) throws Exception {
        NiceXWPFDocument document = context.getXWPFDocument();
        XWPFRun run = context.getRun();
        List<Object> datas = context.getData();
        for (Object data : datas) {
            if (data instanceof TextRenderData) {
                XWPFRun createRun = document.insertNewParagraph(run).createRun();
                StyleUtils.styleRun(createRun, run);
                TextRenderPolicy.Helper.renderTextRun(createRun, data);
                continue;
            }
            if (data instanceof MiniTableRenderData) {
                MiniTableRenderPolicy.Helper.renderMiniTable(run, (MiniTableRenderData)data);
                continue;
            }
            if (data instanceof NumbericRenderData) {
                NumbericRenderPolicy.Helper.renderNumberic(run, (NumbericRenderData)data);
                continue;
            }
            if (!(data instanceof PictureRenderData)) continue;
            PictureRenderPolicy.Helper.renderPicture(document.insertNewParagraph(run).createRun(), (PictureRenderData)data);
        }
    }

    @Override
    protected void afterRender(RenderContext<List<Object>> context) {
        ListRenderPolicy.clearPlaceholder(context, true);
    }
}

