/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.DocxRenderData;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class DocxRenderPolicy
extends AbstractRenderPolicy<DocxRenderData> {
    @Override
    protected boolean validate(DocxRenderData data) {
        return null != data && null != data.getDocx();
    }

    @Override
    protected void beforeRender(RenderContext<DocxRenderData> context) {
        DocxRenderPolicy.clearPlaceholder(context, false);
    }

    @Override
    public void doRender(RenderContext<DocxRenderData> context) throws Exception {
        NiceXWPFDocument doc = context.getXWPFDocument();
        XWPFTemplate template = context.getTemplate();
        doc = doc.merge(new XWPFDocumentIterator(context.getData(), context.getConfig()), context.getRun());
        template.reload(doc);
    }

    class XWPFDocumentIterator
    implements Iterator<NiceXWPFDocument> {
        private Configure config;
        private byte[] docx;
        private List<?> datas;
        int cursor = 0;

        XWPFDocumentIterator(DocxRenderData data, Configure config) {
            this.docx = data.getDocx();
            this.datas = data.getDataModels();
            this.config = config;
        }

        @Override
        public boolean hasNext() {
            if (CollectionUtils.isEmpty(this.datas)) {
                return this.cursor != Integer.MAX_VALUE;
            }
            return this.cursor < this.datas.size();
        }

        @Override
        public NiceXWPFDocument next() {
            if (CollectionUtils.isEmpty(this.datas)) {
                if (this.cursor != Integer.MAX_VALUE) {
                    try {
                        this.cursor = Integer.MAX_VALUE;
                        return new NiceXWPFDocument(new ByteArrayInputStream(this.docx));
                    }
                    catch (IOException e) {
                        throw new RenderException("Next NiceXWPFDocument", e);
                    }
                }
            } else {
                XWPFTemplate temp = XWPFTemplate.compile(new ByteArrayInputStream(this.docx), this.config);
                temp.render(this.datas.get(this.cursor++));
                return temp.getXWPFDocument();
            }
            return null;
        }
    }
}

