/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.resolver;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.exception.ResolverException;
import com.deepoove.poi.resolver.AbstractResolver;
import com.deepoove.poi.resolver.RunTemplateFactory;
import com.deepoove.poi.resolver.RunningRunParagraph;
import com.deepoove.poi.template.BlockTemplate;
import com.deepoove.poi.template.IterableTemplate;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateResolver
extends AbstractResolver {
    private static Logger logger = LoggerFactory.getLogger(TemplateResolver.class);
    private RunTemplateFactory<?> runTemplateFactory;

    public TemplateResolver(Configure config) {
        this(config, config.getRunTemplateFactory());
    }

    private TemplateResolver(Configure config, RunTemplateFactory<?> runTemplateFactory) {
        super(config);
        this.runTemplateFactory = runTemplateFactory;
    }

    @Override
    public List<MetaTemplate> resolveDocument(XWPFDocument doc) {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        if (null == doc) {
            return metaTemplates;
        }
        logger.info("Resolve the document start...");
        metaTemplates.addAll(this.resolveBodyElements(doc.getBodyElements()));
        metaTemplates.addAll(this.resolveHeaders(doc.getHeaderList()));
        metaTemplates.addAll(this.resolveFooters(doc.getFooterList()));
        logger.info("Resolve the document end, resolve and create {} MetaTemplates.", (Object)metaTemplates.size());
        return metaTemplates;
    }

    @Override
    public List<MetaTemplate> resolveBodyElements(List<IBodyElement> bodyElements) {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        if (null == bodyElements) {
            return metaTemplates;
        }
        LinkedList<BlockTemplate> stack = new LinkedList<BlockTemplate>();
        for (IBodyElement element : bodyElements) {
            XWPFTable table;
            List rows;
            if (element == null) continue;
            if (element.getElementType() == BodyElementType.PARAGRAPH) {
                XWPFParagraph paragraph = (XWPFParagraph)element;
                RunningRunParagraph runningRun = new RunningRunParagraph(paragraph, this.templatePattern);
                List<XWPFRun> refactorRuns = runningRun.refactorRun();
                if (null == refactorRuns) continue;
                Collections.reverse(refactorRuns);
                this.resolveXWPFRuns(refactorRuns, metaTemplates, stack);
                continue;
            }
            if (element.getElementType() != BodyElementType.TABLE || null == (rows = (table = (XWPFTable)element).getRows())) continue;
            for (XWPFTableRow row : rows) {
                List cells = row.getTableCells();
                if (null == cells) continue;
                cells.forEach(cell -> {
                    List<MetaTemplate> visitBodyElements = this.resolveBodyElements(cell.getBodyElements());
                    if (stack.isEmpty()) {
                        metaTemplates.addAll(visitBodyElements);
                    } else {
                        ((BlockTemplate)stack.peek()).getTemplates().addAll(visitBodyElements);
                    }
                });
            }
        }
        this.checkStack(stack);
        return metaTemplates;
    }

    @Override
    public List<MetaTemplate> resolveXWPFRuns(List<XWPFRun> runs) {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        if (runs == null) {
            return metaTemplates;
        }
        LinkedList<BlockTemplate> stack = new LinkedList<BlockTemplate>();
        this.resolveXWPFRuns(runs, metaTemplates, stack);
        this.checkStack(stack);
        return metaTemplates;
    }

    private void resolveXWPFRuns(List<XWPFRun> runs, List<MetaTemplate> metaTemplates, Deque<BlockTemplate> stack) {
        for (XWPFRun run : runs) {
            RunTemplate runTemplate;
            String text = null;
            if (null == run || StringUtils.isBlank((CharSequence)(text = run.getText(0))) || null == (runTemplate = this.parseTemplateFactory(text, run))) continue;
            char charValue = runTemplate.getSign().charValue();
            if (charValue == ((Character)this.config.getIterable().getLeft()).charValue()) {
                IterableTemplate freshIterableTemplate = new IterableTemplate(runTemplate);
                stack.push(freshIterableTemplate);
                continue;
            }
            if (charValue == ((Character)this.config.getIterable().getRight()).charValue()) {
                if (stack.isEmpty()) {
                    throw new ResolverException("Mismatched start/end tags: No start mark found for end mark " + runTemplate);
                }
                BlockTemplate latestIterableTemplate = stack.pop();
                if (StringUtils.isNotEmpty((CharSequence)runTemplate.getTagName()) && !latestIterableTemplate.getStartMark().getTagName().equals(runTemplate.getTagName())) {
                    throw new ResolverException("Mismatched start/end tags: start mark " + latestIterableTemplate.getStartMark() + " does not match to end mark " + runTemplate);
                }
                latestIterableTemplate.setEndMark(runTemplate);
                if (latestIterableTemplate instanceof IterableTemplate) {
                    latestIterableTemplate = ((IterableTemplate)latestIterableTemplate).buildIfInline();
                }
                if (stack.isEmpty()) {
                    metaTemplates.add(latestIterableTemplate);
                    continue;
                }
                stack.peek().getTemplates().add(latestIterableTemplate);
                continue;
            }
            if (stack.isEmpty()) {
                metaTemplates.add(runTemplate);
                continue;
            }
            stack.peek().getTemplates().add(runTemplate);
        }
    }

    private void checkStack(Deque<BlockTemplate> stack) {
        if (!stack.isEmpty()) {
            throw new ResolverException("Mismatched start/end tags: No end iterable mark found for start mark " + stack.peek());
        }
    }

    List<MetaTemplate> resolveHeaders(List<XWPFHeader> headers) {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        if (null == headers) {
            return metaTemplates;
        }
        headers.forEach(header -> metaTemplates.addAll(this.resolveBodyElements(header.getBodyElements())));
        return metaTemplates;
    }

    List<MetaTemplate> resolveFooters(List<XWPFFooter> footers) {
        ArrayList<MetaTemplate> metaTemplates = new ArrayList<MetaTemplate>();
        if (null == footers) {
            return metaTemplates;
        }
        footers.forEach(footer -> metaTemplates.addAll(this.resolveBodyElements(footer.getBodyElements())));
        return metaTemplates;
    }

    <T> RunTemplate parseTemplateFactory(String text, T obj) {
        logger.debug("Resolve where text: {}, and create ElementTemplate", (Object)text);
        if (this.templatePattern.matcher(text).matches()) {
            String tag = this.gramerPattern.matcher(text).replaceAll("").trim();
            if (obj.getClass() == XWPFRun.class) {
                return this.runTemplateFactory.createRunTemplate(tag, (XWPFRun)obj);
            }
            if (obj.getClass() == XWPFTableCell.class) {
                return null;
            }
        }
        return null;
    }
}

