/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.operations;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.ClientEndpointManagerImpl;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.UrgentSystemOperation;
import java.io.IOException;
import java.util.Set;

public class ClientDisconnectionOperation
extends AbstractOperation
implements UrgentSystemOperation {
    private String clientUuid;

    public ClientDisconnectionOperation() {
    }

    public ClientDisconnectionOperation(String clientUuid) {
        this.clientUuid = clientUuid;
    }

    @Override
    public void run() throws Exception {
        ClientEngineImpl engine = (ClientEngineImpl)this.getService();
        ClientEndpointManagerImpl endpointManager = (ClientEndpointManagerImpl)engine.getEndpointManager();
        Set<ClientEndpoint> endpoints = endpointManager.getEndpoints(this.clientUuid);
        for (ClientEndpoint clientEndpoint : endpoints) {
            Connection clientEndpointConnection = null != clientEndpoint ? clientEndpoint.getConnection() : null;
            if (null == clientEndpointConnection || !clientEndpointConnection.isAlive()) continue;
            this.getLogger().finest("Will not do the cleanup for client " + this.clientUuid + " since there exists a live connection " + clientEndpointConnection + " from " + "this client");
            return;
        }
        engine.removeClient(this.clientUuid);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.clientUuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.clientUuid = in.readUTF();
    }
}

