/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionStateGenerator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.membergroup.MemberGroup;
import com.hazelcast.partition.membergroup.SingleMemberGroup;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

final class PartitionStateGeneratorImpl
implements PartitionStateGenerator {
    private static final ILogger LOGGER = Logger.getLogger(PartitionStateGenerator.class);
    private static final int DEFAULT_RETRY_MULTIPLIER = 10;
    private static final float RANGE_CHECK_RATIO = 1.1f;
    private static final int MAX_RETRY_COUNT = 3;
    private static final int AGGRESSIVE_RETRY_THRESHOLD = 1;
    private static final int AGGRESSIVE_INDEX_THRESHOLD = 3;
    private static final int MIN_AVG_OWNER_DIFF = 3;

    PartitionStateGeneratorImpl() {
    }

    @Override
    public Address[][] arrange(Collection<MemberGroup> memberGroups, InternalPartition[] currentState) {
        Queue<NodeGroup> groups = this.createNodeGroups(memberGroups);
        if (groups.isEmpty()) {
            return null;
        }
        int partitionCount = currentState.length;
        Address[][] state = new Address[partitionCount][7];
        this.initialize(currentState, state);
        int tryCount = 0;
        do {
            boolean aggressive = tryCount >= 1;
            this.tryArrange(state, groups, partitionCount, aggressive);
            if (tryCount++ <= 0 || !LOGGER.isFineEnabled()) continue;
            LOGGER.fine("Re-trying partition arrangement. Count: " + tryCount);
        } while (tryCount < 3 && !this.areGroupsBalanced(groups, partitionCount));
        return state;
    }

    private void initialize(InternalPartition[] currentState, Address[][] state) {
        int partitionCount = currentState.length;
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            InternalPartition p = currentState[partitionId];
            Address[] replicas = state[partitionId];
            boolean empty = true;
            for (int index = 0; index < 7; ++index) {
                replicas[index] = p.getReplicaAddress(index);
                empty &= replicas[index] == null;
            }
            if (empty) continue;
            int maxReplicaIndex = 6;
            block2: for (int index = 0; index < 7; ++index) {
                if (replicas[index] != null) continue;
                for (int k = maxReplicaIndex; k > index; --k) {
                    if (replicas[k] == null) continue;
                    replicas[index] = replicas[k];
                    replicas[k] = null;
                    maxReplicaIndex = k - 1;
                    continue block2;
                }
            }
        }
    }

    private void tryArrange(Address[][] state, Queue<NodeGroup> groups, int partitionCount, boolean aggressive) {
        int groupSize = groups.size();
        int replicaCount = Math.min(groupSize, 7);
        int avgPartitionPerGroup = partitionCount / groupSize;
        this.initializeGroupPartitions(state, groups, replicaCount, aggressive);
        for (int index = 0; index < replicaCount; ++index) {
            Queue<Integer> freePartitions = this.getUnownedPartitions(state, index);
            LinkedList<NodeGroup> underLoadedGroups = new LinkedList<NodeGroup>();
            LinkedList<NodeGroup> overLoadedGroups = new LinkedList<NodeGroup>();
            int plusOneGroupCount = partitionCount - avgPartitionPerGroup * groupSize;
            for (NodeGroup nodeGroup : groups) {
                int size = nodeGroup.getPartitionCount(index);
                if (size < avgPartitionPerGroup) {
                    underLoadedGroups.add(nodeGroup);
                    continue;
                }
                if (size <= avgPartitionPerGroup) continue;
                overLoadedGroups.add(nodeGroup);
            }
            plusOneGroupCount = this.tryToDistributeUnownedPartitions(underLoadedGroups, freePartitions, avgPartitionPerGroup, index, plusOneGroupCount);
            if (!freePartitions.isEmpty()) {
                this.distributeUnownedPartitions(groups, freePartitions, index);
            }
            assert (freePartitions.isEmpty()) : "There are partitions not-owned yet: " + freePartitions;
            this.transferPartitionsBetweenGroups(underLoadedGroups, overLoadedGroups, index, avgPartitionPerGroup, plusOneGroupCount);
            this.updatePartitionState(state, groups, index);
        }
    }

    private void transferPartitionsBetweenGroups(Queue<NodeGroup> underLoadedGroups, Collection<NodeGroup> overLoadedGroups, int index, int avgPartitionPerGroup, int plusOneGroupCount) {
        int expectedPartitionCount;
        int maxPartitionPerGroup = avgPartitionPerGroup + 1;
        int maxTries = underLoadedGroups.size() * overLoadedGroups.size() * 10;
        int tries = 0;
        int n = expectedPartitionCount = plusOneGroupCount > 0 ? maxPartitionPerGroup : avgPartitionPerGroup;
        while (tries++ < maxTries && !underLoadedGroups.isEmpty()) {
            NodeGroup toGroup = underLoadedGroups.poll();
            Iterator<NodeGroup> overLoadedGroupsIterator = overLoadedGroups.iterator();
            while (overLoadedGroupsIterator.hasNext()) {
                NodeGroup fromGroup = overLoadedGroupsIterator.next();
                this.selectToGroupPartitions(index, expectedPartitionCount, toGroup, fromGroup);
                int fromCount = fromGroup.getPartitionCount(index);
                if (plusOneGroupCount > 0 && fromCount == maxPartitionPerGroup && --plusOneGroupCount == 0) {
                    expectedPartitionCount = avgPartitionPerGroup;
                }
                if (fromCount <= expectedPartitionCount) {
                    overLoadedGroupsIterator.remove();
                }
                int toCount = toGroup.getPartitionCount(index);
                if (plusOneGroupCount > 0 && toCount == maxPartitionPerGroup && --plusOneGroupCount == 0) {
                    expectedPartitionCount = avgPartitionPerGroup;
                }
                if (toCount < expectedPartitionCount) continue;
                break;
            }
            if (toGroup.getPartitionCount(index) >= avgPartitionPerGroup) continue;
            underLoadedGroups.offer(toGroup);
        }
    }

    private void selectToGroupPartitions(int index, int expectedPartitionCount, NodeGroup toGroup, NodeGroup fromGroup) {
        Iterator<Integer> partitionsIterator = fromGroup.getPartitionsIterator(index);
        while (partitionsIterator.hasNext() && fromGroup.getPartitionCount(index) > expectedPartitionCount && toGroup.getPartitionCount(index) < expectedPartitionCount) {
            Integer partitionId = partitionsIterator.next();
            if (!toGroup.addPartition(index, partitionId)) continue;
            partitionsIterator.remove();
        }
    }

    private void updatePartitionState(Address[][] state, Collection<NodeGroup> groups, int index) {
        for (NodeGroup group : groups) {
            group.postProcessPartitionTable(index);
            for (Address address : group.getNodes()) {
                PartitionTable table = group.getPartitionTable(address);
                Set<Integer> set = table.getPartitions(index);
                for (Integer partitionId : set) {
                    state[partitionId.intValue()][index] = address;
                }
            }
        }
    }

    private void distributeUnownedPartitions(Queue<NodeGroup> groups, Queue<Integer> freePartitions, int index) {
        int groupSize = groups.size();
        int maxTries = freePartitions.size() * groupSize * 10;
        int tries = 0;
        Integer partitionId = freePartitions.poll();
        while (partitionId != null && tries++ < maxTries) {
            NodeGroup group = groups.poll();
            if (group.addPartition(index, partitionId)) {
                partitionId = freePartitions.poll();
            }
            groups.offer(group);
        }
    }

    private int tryToDistributeUnownedPartitions(Queue<NodeGroup> underLoadedGroups, Queue<Integer> freePartitions, int avgPartitionPerGroup, int index, int plusOneGroupCount) {
        int maxPartitionPerGroup = avgPartitionPerGroup + 1;
        int maxTries = freePartitions.size() * underLoadedGroups.size();
        int tries = 0;
        while (tries++ < maxTries && !freePartitions.isEmpty() && !underLoadedGroups.isEmpty()) {
            NodeGroup group = underLoadedGroups.poll();
            this.assignFreePartitionsToNodeGroup(freePartitions, index, group);
            int count = group.getPartitionCount(index);
            if (plusOneGroupCount > 0 && count == maxPartitionPerGroup) {
                if (--plusOneGroupCount != 0) continue;
                Iterator underLoaded = underLoadedGroups.iterator();
                while (underLoaded.hasNext()) {
                    if (((NodeGroup)underLoaded.next()).getPartitionCount(index) < avgPartitionPerGroup) continue;
                    underLoaded.remove();
                }
                continue;
            }
            if ((plusOneGroupCount <= 0 || count >= maxPartitionPerGroup) && count >= avgPartitionPerGroup) continue;
            underLoadedGroups.offer(group);
        }
        return plusOneGroupCount;
    }

    private void assignFreePartitionsToNodeGroup(Queue<Integer> freePartitions, int index, NodeGroup group) {
        Integer partitionId;
        int size = freePartitions.size();
        for (int i = 0; i < size && !group.addPartition(index, partitionId = freePartitions.poll()); ++i) {
            freePartitions.offer(partitionId);
        }
    }

    private Queue<Integer> getUnownedPartitions(Address[][] state, int replicaIndex) {
        LinkedList<Integer> freePartitions = new LinkedList<Integer>();
        for (int partitionId = 0; partitionId < state.length; ++partitionId) {
            Address[] replicas = state[partitionId];
            if (replicas[replicaIndex] != null) continue;
            freePartitions.add(partitionId);
        }
        Collections.shuffle(freePartitions);
        return freePartitions;
    }

    private void initializeGroupPartitions(Address[][] state, Queue<NodeGroup> groups, int replicaCount, boolean aggressive) {
        for (NodeGroup nodeGroup : groups) {
            nodeGroup.resetPartitions();
        }
        for (int partitionId = 0; partitionId < state.length; ++partitionId) {
            Address[] replicas = state[partitionId];
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                if (replicaIndex >= replicaCount) {
                    replicas[replicaIndex] = null;
                    continue;
                }
                Address owner = replicas[replicaIndex];
                boolean valid = false;
                if (owner != null) {
                    valid = this.partitionOwnerAvailable(groups, partitionId, replicaIndex, owner);
                }
                if (!valid) {
                    replicas[replicaIndex] = null;
                    continue;
                }
                if (!aggressive || replicaIndex >= 3) continue;
                for (int i = 3; i < replicaCount; ++i) {
                    replicas[i] = null;
                }
            }
        }
    }

    private boolean partitionOwnerAvailable(Queue<NodeGroup> groups, int partitionId, int replicaIndex, Address owner) {
        for (NodeGroup nodeGroup : groups) {
            if (!nodeGroup.hasNode(owner)) continue;
            if (!nodeGroup.ownPartition(owner, replicaIndex, partitionId)) break;
            return true;
        }
        return false;
    }

    private Queue<NodeGroup> createNodeGroups(Collection<MemberGroup> memberGroups) {
        LinkedList<NodeGroup> nodeGroups = new LinkedList<NodeGroup>();
        if (memberGroups == null || memberGroups.isEmpty()) {
            return nodeGroups;
        }
        for (MemberGroup memberGroup : memberGroups) {
            NodeGroup nodeGroup;
            if (memberGroup.size() == 0) continue;
            if (memberGroup instanceof SingleMemberGroup || memberGroup.size() == 1) {
                nodeGroup = new SingleNodeGroup();
                MemberImpl next = (MemberImpl)memberGroup.iterator().next();
                nodeGroup.addNode(next.getAddress());
            } else {
                nodeGroup = new DefaultNodeGroup();
                Iterator<Member> iter = memberGroup.iterator();
                while (iter.hasNext()) {
                    MemberImpl next = (MemberImpl)iter.next();
                    nodeGroup.addNode(next.getAddress());
                }
            }
            nodeGroups.add(nodeGroup);
        }
        return nodeGroups;
    }

    private boolean areGroupsBalanced(Collection<NodeGroup> groups, int partitionCount) {
        float ratio = 1.1f;
        int avgPartitionPerGroup = partitionCount / groups.size();
        int replicaCount = Math.min(groups.size(), 7);
        for (NodeGroup group : groups) {
            for (int i = 0; i < replicaCount; ++i) {
                int partitionCountOfGroup = group.getPartitionCount(i);
                if (Math.abs(partitionCountOfGroup - avgPartitionPerGroup) <= 3 || !((float)partitionCountOfGroup < (float)avgPartitionPerGroup / ratio) && !((float)partitionCountOfGroup > (float)avgPartitionPerGroup * ratio)) continue;
                if (LOGGER.isFineEnabled()) {
                    LOGGER.fine("Not well balanced! Replica: " + i + ", PartitionCount: " + partitionCountOfGroup + ", AvgPartitionCount: " + avgPartitionPerGroup);
                }
                return false;
            }
        }
        return true;
    }

    private static class PartitionTable {
        final Set<Integer>[] partitions = new Set[7];

        private PartitionTable() {
        }

        Set<Integer> getPartitions(int index) {
            this.check(index);
            Set<Integer> set = this.partitions[index];
            if (set == null) {
                this.partitions[index] = set = new LinkedHashSet<Integer>();
            }
            return set;
        }

        boolean add(int index, Integer partitionId) {
            return this.getPartitions(index).add(partitionId);
        }

        boolean contains(int index, Integer partitionId) {
            return this.getPartitions(index).contains(partitionId);
        }

        boolean contains(Integer partitionId) {
            for (Set<Integer> set : this.partitions) {
                if (set == null || !set.contains(partitionId)) continue;
                return true;
            }
            return false;
        }

        boolean remove(int index, Integer partitionId) {
            return this.getPartitions(index).remove(partitionId);
        }

        int size(int index) {
            return this.getPartitions(index).size();
        }

        void reset() {
            for (Set<Integer> set : this.partitions) {
                if (set == null) continue;
                set.clear();
            }
        }

        private void check(int index) {
            if (index < 0 || index >= 7) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }
    }

    private static class SingleNodeGroup
    implements NodeGroup {
        final PartitionTable nodeTable = new PartitionTable();
        Address address;
        Set<Address> nodes;

        private SingleNodeGroup() {
        }

        @Override
        public void addNode(Address addr) {
            if (this.address != null) {
                LOGGER.warning("Single node group already has an address => " + this.address);
                return;
            }
            this.address = addr;
            this.nodes = Collections.singleton(this.address);
        }

        @Override
        public boolean hasNode(Address address) {
            return this.address != null && this.address.equals(address);
        }

        @Override
        public Set<Address> getNodes() {
            return this.nodes;
        }

        @Override
        public PartitionTable getPartitionTable(Address address) {
            return this.hasNode(address) ? this.nodeTable : null;
        }

        @Override
        public void resetPartitions() {
            this.nodeTable.reset();
        }

        @Override
        public int getPartitionCount(int index) {
            return this.nodeTable.size(index);
        }

        private boolean containsPartition(Integer partitionId) {
            return this.nodeTable.contains(partitionId);
        }

        @Override
        public boolean ownPartition(Address address, int index, Integer partitionId) {
            if (!this.hasNode(address)) {
                String error = address + " is different from this node's " + this.address;
                LOGGER.warning(error);
                return false;
            }
            if (this.containsPartition(partitionId)) {
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.finest("Partition[" + partitionId + "] is already owned by this node " + address);
                }
                return false;
            }
            return this.nodeTable.add(index, partitionId);
        }

        @Override
        public boolean addPartition(int replicaIndex, Integer partitionId) {
            if (this.containsPartition(partitionId)) {
                return false;
            }
            return this.nodeTable.add(replicaIndex, partitionId);
        }

        @Override
        public Iterator<Integer> getPartitionsIterator(int index) {
            return this.nodeTable.getPartitions(index).iterator();
        }

        @Override
        public void postProcessPartitionTable(int index) {
        }

        public String toString() {
            return "SingleNodeGroupRegistry [address=" + this.address + "]";
        }
    }

    private static class DefaultNodeGroup
    implements NodeGroup {
        final PartitionTable groupPartitionTable = new PartitionTable();
        final Map<Address, PartitionTable> nodePartitionTables = new HashMap<Address, PartitionTable>();
        final LinkedList<Integer> partitionQ = new LinkedList();

        private DefaultNodeGroup() {
        }

        @Override
        public void addNode(Address address) {
            this.nodePartitionTables.put(address, new PartitionTable());
        }

        @Override
        public boolean hasNode(Address address) {
            return this.nodePartitionTables.containsKey(address);
        }

        @Override
        public Set<Address> getNodes() {
            return this.nodePartitionTables.keySet();
        }

        @Override
        public PartitionTable getPartitionTable(Address address) {
            return this.nodePartitionTables.get(address);
        }

        @Override
        public void resetPartitions() {
            this.groupPartitionTable.reset();
            this.partitionQ.clear();
            for (PartitionTable table : this.nodePartitionTables.values()) {
                table.reset();
            }
        }

        @Override
        public int getPartitionCount(int index) {
            return this.groupPartitionTable.size(index);
        }

        private boolean containsPartition(Integer partitionId) {
            return this.groupPartitionTable.contains(partitionId);
        }

        @Override
        public boolean ownPartition(Address address, int index, Integer partitionId) {
            if (!this.hasNode(address)) {
                String error = "Address does not belong to this group: " + address.toString();
                LOGGER.warning(error);
                return false;
            }
            if (this.containsPartition(partitionId)) {
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.finest("Partition[" + partitionId + "] is already owned by this group!");
                }
                return false;
            }
            this.groupPartitionTable.add(index, partitionId);
            return this.nodePartitionTables.get(address).add(index, partitionId);
        }

        @Override
        public boolean addPartition(int replicaIndex, Integer partitionId) {
            if (this.containsPartition(partitionId)) {
                return false;
            }
            if (this.groupPartitionTable.add(replicaIndex, partitionId)) {
                this.partitionQ.add(partitionId);
                return true;
            }
            return false;
        }

        @Override
        public Iterator<Integer> getPartitionsIterator(final int index) {
            final Iterator<Integer> iterator = this.groupPartitionTable.getPartitions(index).iterator();
            return new Iterator<Integer>(){
                Integer current;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Integer next() {
                    this.current = (Integer)iterator.next();
                    return this.current;
                }

                @Override
                public void remove() {
                    iterator.remove();
                    DefaultNodeGroup.this.doRemovePartition(index, this.current);
                }
            };
        }

        private void doRemovePartition(int index, Integer partitionId) {
            for (PartitionTable table : this.nodePartitionTables.values()) {
                if (table.remove(index, partitionId)) break;
            }
        }

        @Override
        public void postProcessPartitionTable(int index) {
            if (this.nodePartitionTables.size() == 1) {
                PartitionTable table = this.nodePartitionTables.values().iterator().next();
                while (!this.partitionQ.isEmpty()) {
                    table.add(index, this.partitionQ.poll());
                }
            } else {
                LinkedList<PartitionTable> underLoadedStates = new LinkedList<PartitionTable>();
                int avgCount = this.slimDownNodesToAvgPartitionTableSize(index, underLoadedStates);
                if (!this.partitionQ.isEmpty()) {
                    for (PartitionTable table : underLoadedStates) {
                        while (table.size(index) < avgCount) {
                            table.add(index, this.partitionQ.poll());
                        }
                    }
                }
                block3: while (!this.partitionQ.isEmpty()) {
                    for (PartitionTable table : this.nodePartitionTables.values()) {
                        table.add(index, this.partitionQ.poll());
                        if (!this.partitionQ.isEmpty()) continue;
                        continue block3;
                    }
                }
            }
        }

        private int slimDownNodesToAvgPartitionTableSize(int index, List<PartitionTable> underLoadedStates) {
            int totalCount = this.getPartitionCount(index);
            int avgCount = totalCount / this.nodePartitionTables.values().size();
            for (PartitionTable table : this.nodePartitionTables.values()) {
                Set<Integer> partitions = table.getPartitions(index);
                if (partitions.size() > avgCount) {
                    Integer[] partitionArray = partitions.toArray(new Integer[partitions.size()]);
                    while (partitions.size() > avgCount) {
                        int partitionId = partitionArray[partitions.size() - 1];
                        partitions.remove(partitionId);
                        this.partitionQ.add(partitionId);
                    }
                    continue;
                }
                underLoadedStates.add(table);
            }
            return avgCount;
        }

        public String toString() {
            return "DefaultNodeGroupRegistry [nodes=" + this.nodePartitionTables.keySet() + "]";
        }
    }

    private static interface NodeGroup {
        public void addNode(Address var1);

        public boolean hasNode(Address var1);

        public Set<Address> getNodes();

        public PartitionTable getPartitionTable(Address var1);

        public void resetPartitions();

        public int getPartitionCount(int var1);

        public boolean ownPartition(Address var1, int var2, Integer var3);

        public boolean addPartition(int var1, Integer var2);

        public Iterator<Integer> getPartitionsIterator(int var1);

        public void postProcessPartitionTable(int var1);
    }
}

