/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl.operations;

import com.hazelcast.client.impl.operations.OperationFactoryWrapper;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareFactoryAccessor;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ResponseQueueFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;

public final class PartitionIteratingOperation
extends Operation
implements IdentifiedDataSerializable {
    private OperationFactory operationFactory;
    private int[] partitions;
    private Object[] results;

    public PartitionIteratingOperation() {
    }

    public PartitionIteratingOperation(OperationFactory operationFactory, List<Integer> partitions) {
        this.operationFactory = operationFactory;
        this.partitions = CollectionUtil.toIntArray(partitions);
    }

    @Override
    public void run() throws Exception {
        try {
            PartitionAwareOperationFactory partitionAware = PartitionAwareFactoryAccessor.extractPartitionAware(this.operationFactory);
            Object[] responses = partitionAware != null ? this.executePartitionAwareOperations(partitionAware) : this.executeOperations();
            this.results = this.resolveResponses(responses);
        }
        catch (Exception e) {
            this.getLogger(this.getNodeEngine()).severe(e);
        }
    }

    private Object[] executeOperations() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Object[] responses = new Object[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            ResponseQueue responseQueue = new ResponseQueue();
            responses[i] = responseQueue;
            Operation operation = this.operationFactory.createOperation();
            operation.setNodeEngine(nodeEngine).setPartitionId(this.partitions[i]).setReplicaIndex(this.getReplicaIndex()).setOperationResponseHandler(responseQueue).setServiceName(this.getServiceName()).setService(this.getService()).setCallerUuid(this.extractCallerUuid());
            OperationAccessor.setCallerAddress(operation, this.getCallerAddress());
            nodeEngine.getOperationService().execute(operation);
        }
        return responses;
    }

    private String extractCallerUuid() {
        if (this.operationFactory instanceof OperationFactoryWrapper) {
            return ((OperationFactoryWrapper)this.operationFactory).getUuid();
        }
        return this.getCallerUuid();
    }

    private Object[] executePartitionAwareOperations(PartitionAwareOperationFactory givenFactory) {
        PartitionAwareOperationFactory factory = givenFactory.createFactoryOnRunner(this.getNodeEngine());
        NodeEngine nodeEngine = this.getNodeEngine();
        int[] operationFactoryPartitions = factory.getPartitions();
        this.partitions = operationFactoryPartitions == null ? this.partitions : operationFactoryPartitions;
        Object[] responses = new Object[this.partitions.length];
        for (int i = 0; i < this.partitions.length; ++i) {
            ResponseQueue responseQueue = new ResponseQueue();
            responses[i] = responseQueue;
            int partition = this.partitions[i];
            Operation operation = factory.createPartitionOperation(partition);
            operation.setNodeEngine(nodeEngine).setPartitionId(partition).setReplicaIndex(this.getReplicaIndex()).setOperationResponseHandler(responseQueue).setServiceName(this.getServiceName()).setService(this.getService()).setCallerUuid(this.extractCallerUuid());
            OperationAccessor.setCallerAddress(operation, this.getCallerAddress());
            nodeEngine.getOperationService().execute(operation);
        }
        return responses;
    }

    private Object[] resolveResponses(Object[] responses) throws InterruptedException {
        for (int i = 0; i < responses.length; ++i) {
            ResponseQueue queue = (ResponseQueue)responses[i];
            Object result = queue.get();
            responses[i] = result instanceof NormalResponse ? ((NormalResponse)result).getValue() : result;
        }
        return responses;
    }

    private ILogger getLogger(NodeEngine nodeEngine) {
        return nodeEngine.getLogger(PartitionIteratingOperation.class.getName());
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public Object getResponse() {
        return new PartitionResponse(this.partitions, this.results);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", operationFactory=").append(this.operationFactory);
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.operationFactory);
        out.writeIntArray(this.partitions);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.operationFactory = (OperationFactory)in.readObject();
        this.partitions = in.readIntArray();
    }

    public static final class PartitionResponse
    implements IdentifiedDataSerializable {
        private int[] partitions;
        private Object[] results;

        public PartitionResponse() {
        }

        PartitionResponse(int[] partitions, Object[] results) {
            this.partitions = partitions;
            this.results = results;
        }

        public void addResults(Map<Integer, Object> partitionResults) {
            if (this.results == null) {
                return;
            }
            for (int i = 0; i < this.results.length; ++i) {
                partitionResults.put(this.partitions[i], this.results[i]);
            }
        }

        @Override
        public int getFactoryId() {
            return SpiDataSerializerHook.F_ID;
        }

        @Override
        public int getId() {
            return 4;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeIntArray(this.partitions);
            int resultLength = this.results != null ? this.results.length : 0;
            out.writeInt(resultLength);
            if (resultLength > 0) {
                for (Object result : this.results) {
                    out.writeObject(result);
                }
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.partitions = in.readIntArray();
            int resultLength = in.readInt();
            if (resultLength > 0) {
                this.results = new Object[resultLength];
                for (int i = 0; i < resultLength; ++i) {
                    this.results[i] = in.readObject();
                }
            }
        }
    }

    private static class ResponseQueue
    implements OperationResponseHandler {
        private final BlockingQueue<Object> queue = ResponseQueueFactory.newResponseQueue();

        private ResponseQueue() {
        }

        public void sendResponse(Operation op, Object obj) {
            if (!this.queue.offer(obj)) {
                throw new HazelcastException("Response could not be queued for transportation");
            }
        }

        public Object get() throws InterruptedException {
            return this.queue.take();
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }
}

