/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPDITContentRuleSchema
extends LDAPSchemaElement {
    private String[] auxiliary = new String[]{""};
    private String[] required = new String[]{""};
    private String[] optional = new String[]{""};
    private String[] precluded = new String[]{""};

    public LDAPDITContentRuleSchema() {
        super(LDAPSchema.schemaTypeNames[4]);
    }

    public LDAPDITContentRuleSchema(String[] names, String oid, String description, boolean obsolete, String[] auxiliary, String[] required, String[] optional, String[] precluded) {
        super(LDAPSchema.schemaTypeNames[4]);
        this.names = (String[])names.clone();
        this.oid = oid;
        this.description = description;
        this.obsolete = obsolete;
        this.auxiliary = auxiliary;
        this.required = required;
        this.optional = optional;
        this.precluded = precluded;
        super.setValue(this.formatString());
    }

    public LDAPDITContentRuleSchema(String raw) {
        super(LDAPSchema.schemaTypeNames[4]);
        this.obsolete = false;
        try {
            SchemaParser parser = new SchemaParser(raw);
            if (parser.getNames() != null) {
                this.names = (String[])parser.getNames().clone();
            }
            if (parser.getID() != null) {
                this.oid = parser.getID();
            }
            if (parser.getDescription() != null) {
                this.description = parser.getDescription();
            }
            if (parser.getAuxiliary() != null) {
                this.auxiliary = (String[])parser.getAuxiliary().clone();
            }
            if (parser.getRequired() != null) {
                this.required = (String[])parser.getRequired().clone();
            }
            if (parser.getOptional() != null) {
                this.optional = (String[])parser.getOptional().clone();
            }
            if (parser.getPrecluded() != null) {
                this.precluded = (String[])parser.getPrecluded().clone();
            }
            this.obsolete = parser.getObsolete();
            Enumeration qualifiers = parser.getQualifiers();
            while (qualifiers.hasMoreElements()) {
                AttributeQualifier attrQualifier = (AttributeQualifier)qualifiers.nextElement();
                this.setQualifier(attrQualifier.getName(), attrQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String[] getAuxiliaryClasses() {
        return this.auxiliary;
    }

    public String[] getRequiredAttributes() {
        return this.required;
    }

    public String[] getOptionalAttributes() {
        return this.optional;
    }

    public String[] getPrecludedAttributes() {
        return this.precluded;
    }

    protected String formatString() {
        Enumeration en;
        int i;
        String[] strArray;
        StringBuffer valueBuffer = new StringBuffer("( ");
        String token = this.getID();
        if (token != null) {
            valueBuffer.append(token);
        }
        if ((strArray = this.getNames()) != null) {
            valueBuffer.append(" NAME ");
            if (strArray.length == 1) {
                valueBuffer.append("'" + strArray[0] + "'");
            } else {
                valueBuffer.append("( ");
                for (i = 0; i < strArray.length; ++i) {
                    valueBuffer.append(" '" + strArray[i] + "'");
                }
                valueBuffer.append(" )");
            }
        }
        if ((token = this.getDescription()) != null) {
            valueBuffer.append(" DESC ");
            valueBuffer.append("'" + token + "'");
        }
        if (this.isObsolete()) {
            valueBuffer.append(" OBSOLETE");
        }
        if ((strArray = this.getAuxiliaryClasses()) != null) {
            valueBuffer.append(" AUX ");
            if (strArray.length > 1) {
                valueBuffer.append("( ");
            }
            for (i = 0; i < strArray.length; ++i) {
                if (i > 0) {
                    valueBuffer.append(" $ ");
                }
                valueBuffer.append(strArray[i]);
            }
            if (strArray.length > 1) {
                valueBuffer.append(" )");
            }
        }
        if ((strArray = this.getRequiredAttributes()) != null) {
            valueBuffer.append(" MUST ");
            if (strArray.length > 1) {
                valueBuffer.append("( ");
            }
            for (i = 0; i < strArray.length; ++i) {
                if (i > 0) {
                    valueBuffer.append(" $ ");
                }
                valueBuffer.append(strArray[i]);
            }
            if (strArray.length > 1) {
                valueBuffer.append(" )");
            }
        }
        if ((strArray = this.getOptionalAttributes()) != null) {
            valueBuffer.append(" MAY ");
            if (strArray.length > 1) {
                valueBuffer.append("( ");
            }
            for (i = 0; i < strArray.length; ++i) {
                if (i > 0) {
                    valueBuffer.append(" $ ");
                }
                valueBuffer.append(strArray[i]);
            }
            if (strArray.length > 1) {
                valueBuffer.append(" )");
            }
        }
        if ((strArray = this.getPrecludedAttributes()) != null) {
            valueBuffer.append(" NOT ");
            if (strArray.length > 1) {
                valueBuffer.append("( ");
            }
            for (i = 0; i < strArray.length; ++i) {
                if (i > 0) {
                    valueBuffer.append(" $ ");
                }
                valueBuffer.append(strArray[i]);
            }
            if (strArray.length > 1) {
                valueBuffer.append(" )");
            }
        }
        if ((en = this.getQualifierNames()) != null) {
            while (en.hasMoreElements()) {
                String qualName = (String)en.nextElement();
                valueBuffer.append(" " + qualName + " ");
                String[] qualValue = this.getQualifier(qualName);
                if (qualValue == null) continue;
                if (qualValue.length > 1) {
                    valueBuffer.append("( ");
                }
                for (int i2 = 0; i2 < qualValue.length; ++i2) {
                    if (i2 > 0) {
                        valueBuffer.append(" ");
                    }
                    valueBuffer.append("'" + qualValue[i2] + "'");
                }
                if (qualValue.length <= 1) continue;
                valueBuffer.append(" )");
            }
        }
        valueBuffer.append(" )");
        return valueBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream istream) throws IOException {
        LDAPDITContentRuleSchema readObject = (LDAPDITContentRuleSchema)LDAPDITContentRuleSchema.readDSML(istream);
        this.oid = readObject.getID();
        this.names = readObject.getNames();
        this.description = readObject.getDescription();
        this.obsolete = readObject.isObsolete();
        Enumeration enumer = readObject.getQualifierNames();
        while (enumer.hasMoreElements()) {
            String xname = (String)enumer.nextElement();
            String[] qualifierVals = readObject.getQualifier(xname);
            this.setQualifier(xname, qualifierVals);
        }
        super.setValue(this.formatString());
        this.auxiliary = readObject.getAuxiliaryClasses();
        this.required = readObject.getRequiredAttributes();
        this.optional = readObject.getOptionalAttributes();
        this.precluded = readObject.getPrecludedAttributes();
        readObject = null;
    }

    protected void writeValue(Writer out) throws IOException {
        String value = this.formatString();
        out.write(ValueXMLhandler.newLine(2));
        out.write("<value>");
        out.write(value);
        out.write("</value>");
    }

    protected void writeValue(StringBuffer buff) {
        String value = this.formatString();
        buff.append(ValueXMLhandler.newLine(2));
        buff.append("<value>");
        buff.append(value);
        buff.append("</value>");
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPDITContentRuleSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPDITContentRuleSchema)xmlreader.parseXML(input);
    }

    private static LDAPXMLHandler getTopXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPDITContentRuleSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPDITContentRuleSchema)this.valuelist.get(0));
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("attr")) {
                    this.valuelist.add(value);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator valueiterator = this.valuelist.iterator();
                LDAPDITContentRuleSchema attr = new LDAPDITContentRuleSchema(this.attrName);
                byte[] temp = (byte[])valueiterator.next();
                StringBuffer bf = new StringBuffer(temp.length);
                for (int i = 0; i < temp.length; ++i) {
                    bf.append((char)temp[i]);
                }
                try {
                    SchemaParser parser = new SchemaParser(bf.toString());
                    if (parser.getNames() != null) {
                        attr.names = (String[])parser.getNames().clone();
                    }
                    if (parser.getID() != null) {
                        attr.oid = parser.getID();
                    }
                    if (parser.getDescription() != null) {
                        attr.description = parser.getDescription();
                    }
                    if (parser.getAuxiliary() != null) {
                        LDAPDITContentRuleSchema.access$002(attr, (String[])parser.getAuxiliary().clone());
                    }
                    if (parser.getRequired() != null) {
                        LDAPDITContentRuleSchema.access$102(attr, (String[])parser.getRequired().clone());
                    }
                    if (parser.getOptional() != null) {
                        LDAPDITContentRuleSchema.access$202(attr, (String[])parser.getOptional().clone());
                    }
                    if (parser.getPrecluded() != null) {
                        LDAPDITContentRuleSchema.access$302(attr, (String[])parser.getPrecluded().clone());
                    }
                    attr.obsolete = parser.getObsolete();
                    Enumeration qualifiers = parser.getQualifiers();
                    while (qualifiers.hasMoreElements()) {
                        AttributeQualifier attrQualifier = (AttributeQualifier)qualifiers.nextElement();
                        attr.setQualifier(attrQualifier.getName(), attrQualifier.getValues());
                    }
                    attr.setValue(attr.formatString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e.toString());
                }
                this.setObject(attr);
                this.valuelist.clear();
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("value")) {
                    this.valuelist.add(value);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    static /* synthetic */ String[] access$002(LDAPDITContentRuleSchema x0, String[] x1) {
        x0.auxiliary = x1;
        return x1;
    }

    static /* synthetic */ String[] access$102(LDAPDITContentRuleSchema x0, String[] x1) {
        x0.required = x1;
        return x1;
    }

    static /* synthetic */ String[] access$202(LDAPDITContentRuleSchema x0, String[] x1) {
        x0.optional = x1;
        return x1;
    }

    static /* synthetic */ String[] access$302(LDAPDITContentRuleSchema x0, String[] x1) {
        x0.precluded = x1;
        return x1;
    }
}

