/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPSearchResult;
import com.novell.ldap.events.LDAPEvent;
import com.novell.ldap.events.PsearchEventSource;

public class SearchResultEvent
extends LDAPEvent {
    public SearchResultEvent(PsearchEventSource eventsource, LDAPSearchResult source, int atype) {
        super(eventsource, source, 0, atype);
    }

    public final LDAPEntry getEntry() {
        return ((LDAPSearchResult)this.getContainedEventInformation()).getEntry();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[" + this.getClass().getName() + ":");
        buf.append("(Classification=LDAP Persistence Search Event)");
        buf.append("(Type=" + this.getChangeTypeString(this.getType()) + ")");
        buf.append("(EventInformation:" + this.getStringRepresentaionOfEventInformation() + ")");
        buf.append("]");
        return buf.toString();
    }

    private String getStringRepresentaionOfEventInformation() {
        StringBuffer buf = new StringBuffer();
        LDAPSearchResult result = (LDAPSearchResult)this.getContainedEventInformation();
        buf.append("(Entry=" + result.getEntry() + ")");
        LDAPControl[] controls = result.getControls();
        if (controls != null) {
            buf.append("(Controls=");
            for (int i = 0; i < controls.length; ++i) {
                buf.append("(Control" + (i + 1) + "=" + controls[i] + ")");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    private String getChangeTypeString(int changeType) {
        String changeTypeString;
        switch (changeType) {
            case 1: {
                changeTypeString = "ADD";
                break;
            }
            case 4: {
                changeTypeString = "MODIFY";
                break;
            }
            case 8: {
                changeTypeString = "MODDN";
                break;
            }
            case 2: {
                changeTypeString = "DELETE";
                break;
            }
            default: {
                changeTypeString = "No change type: " + String.valueOf(changeType);
            }
        }
        return changeTypeString;
    }
}

