/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPIntermediateResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.client.Debug;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.BinderyObjectEventData;
import com.novell.ldap.events.edir.eventdata.ChangeAddressEventData;
import com.novell.ldap.events.edir.eventdata.ConnectionStateEventData;
import com.novell.ldap.events.edir.eventdata.DebugEventData;
import com.novell.ldap.events.edir.eventdata.EntryEventData;
import com.novell.ldap.events.edir.eventdata.GeneralDSEventData;
import com.novell.ldap.events.edir.eventdata.ModuleStateEventData;
import com.novell.ldap.events.edir.eventdata.NetworkAddressEventData;
import com.novell.ldap.events.edir.eventdata.SecurityEquivalenceEventData;
import com.novell.ldap.events.edir.eventdata.ValueEventData;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.IOException;

public class EdirEventIntermediateResponse
extends LDAPIntermediateResponse {
    private static final int EDIR_TAG_ENTRY_EVENT_DATA = 1;
    private static final int EDIR_TAG_VALUE_EVENT_DATA = 2;
    private static final int EDIR_TAG_GENERAL_EVENT_DATA = 3;
    private static final int EDIR_TAG_SKULK_DATA = 4;
    private static final int EDIR_TAG_BINDERY_EVENT_DATA = 5;
    private static final int EDIR_TAG_DSESEV_INFO = 6;
    private static final int EDIR_TAG_MODULE_STATE_DATA = 7;
    private static final int EDIR_TAG_NETWORK_ADDRESS = 8;
    private static final int EDIR_TAG_CONNECTION_STATE = 9;
    private static final int EDIR_TAG_CHANGE_SERVER_ADDRESS = 12;
    private static final int EDIR_TAG_CHANGE_CONFIG_PARAM = 13;
    private static final int EDIR_TAG_NO_DATA = 14;
    private static final int EDIR_TAG_STATUS_LOG = 15;
    private static final int EDIR_TAG_DEBUG_EVENT_DATA = 16;
    private int eventtype;
    private int eventResult;
    private EventResponseData responsedata;

    public EdirEventIntermediateResponse(RfcLDAPMessage message) throws LDAPException {
        super(message);
        try {
            byte[] returnedValue = this.getValue();
            this.processmessage(returnedValue);
        }
        catch (IOException e) {
            Debug.trace("EventsTrace", "Exception in processing message:" + e.getMessage());
            throw new LDAPException("DECODING_ERROR", 84, e.getMessage());
        }
    }

    public EdirEventIntermediateResponse(byte[] message) throws Exception {
        super(new RfcLDAPMessage(new ASN1Sequence()));
        this.processmessage(message);
    }

    private void processmessage(byte[] returnedValue) throws IOException {
        LBERDecoder decoder = new LBERDecoder();
        ASN1Sequence sequence = (ASN1Sequence)decoder.decode(returnedValue);
        this.eventtype = ((ASN1Integer)sequence.get(0)).intValue();
        this.eventResult = ((ASN1Integer)sequence.get(1)).intValue();
        if (sequence.size() > 2) {
            ASN1Tagged taggedobject = (ASN1Tagged)sequence.get(2);
            switch (taggedobject.getIdentifier().getTag()) {
                case 1: {
                    this.responsedata = new EntryEventData(taggedobject.taggedValue());
                    break;
                }
                case 2: {
                    this.responsedata = new ValueEventData(taggedobject.taggedValue());
                    break;
                }
                case 16: {
                    this.responsedata = new DebugEventData(taggedobject.taggedValue());
                    break;
                }
                case 3: {
                    this.responsedata = new GeneralDSEventData(taggedobject.taggedValue());
                    break;
                }
                case 4: {
                    this.responsedata = null;
                    break;
                }
                case 5: {
                    this.responsedata = new BinderyObjectEventData(taggedobject.taggedValue());
                    break;
                }
                case 6: {
                    this.responsedata = new SecurityEquivalenceEventData(taggedobject.taggedValue());
                    break;
                }
                case 7: {
                    this.responsedata = new ModuleStateEventData(taggedobject.taggedValue());
                    break;
                }
                case 8: {
                    this.responsedata = new NetworkAddressEventData(taggedobject.taggedValue());
                    break;
                }
                case 9: {
                    this.responsedata = new ConnectionStateEventData(taggedobject.taggedValue());
                    break;
                }
                case 12: {
                    this.responsedata = new ChangeAddressEventData(taggedobject.taggedValue());
                    break;
                }
                case 14: {
                    this.responsedata = null;
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
        } else {
            this.responsedata = null;
        }
    }

    public int getEventResult() {
        return this.eventResult;
    }

    public int getEventtype() {
        return this.eventtype;
    }

    public EventResponseData getResponsedata() {
        return this.responsedata;
    }

    public String toString() {
        return "[EdirEventIntermediateResponse(" + this.getMessageID() + "): " + "EventType=" + this.getEventtype() + " ResultCode=" + this.getEventResult() + " ResponseData=" + this.getResponsedata() + "]";
    }
}

