/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.clb.v20180317.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class Listener  extends AbstractModel{

    /**
    * 应用型负载均衡监听器 ID
    */
    @SerializedName("ListenerId")
    @Expose
    private String ListenerId;

    /**
    * 监听器协议
    */
    @SerializedName("Protocol")
    @Expose
    private String Protocol;

    /**
    * 监听器端口
    */
    @SerializedName("Port")
    @Expose
    private Integer Port;

    /**
    * 监听器绑定的证书信息
    */
    @SerializedName("Certificate")
    @Expose
    private CertificateOutput Certificate;

    /**
    * 监听器的健康检查信息
    */
    @SerializedName("HealthCheck")
    @Expose
    private HealthCheck HealthCheck;

    /**
    * 请求调度方式
    */
    @SerializedName("Scheduler")
    @Expose
    private String Scheduler;

    /**
    * 会话保持时间
    */
    @SerializedName("SessionExpireTime")
    @Expose
    private Integer SessionExpireTime;

    /**
    * 是否开启SNI特性（本参数仅对于HTTPS监听器有意义）
    */
    @SerializedName("SniSwitch")
    @Expose
    private Integer SniSwitch;

    /**
    * 监听器下的全部转发规则（本参数仅对于HTTP/HTTPS监听器有意义）
    */
    @SerializedName("Rules")
    @Expose
    private RuleOutput [] Rules;

    /**
    * 监听器的名称
    */
    @SerializedName("ListenerName")
    @Expose
    private String ListenerName;

    /**
     * 获取应用型负载均衡监听器 ID
     * @return ListenerId 应用型负载均衡监听器 ID
     */
    public String getListenerId() {
        return this.ListenerId;
    }

    /**
     * 设置应用型负载均衡监听器 ID
     * @param ListenerId 应用型负载均衡监听器 ID
     */
    public void setListenerId(String ListenerId) {
        this.ListenerId = ListenerId;
    }

    /**
     * 获取监听器协议
     * @return Protocol 监听器协议
     */
    public String getProtocol() {
        return this.Protocol;
    }

    /**
     * 设置监听器协议
     * @param Protocol 监听器协议
     */
    public void setProtocol(String Protocol) {
        this.Protocol = Protocol;
    }

    /**
     * 获取监听器端口
     * @return Port 监听器端口
     */
    public Integer getPort() {
        return this.Port;
    }

    /**
     * 设置监听器端口
     * @param Port 监听器端口
     */
    public void setPort(Integer Port) {
        this.Port = Port;
    }

    /**
     * 获取监听器绑定的证书信息
     * @return Certificate 监听器绑定的证书信息
     */
    public CertificateOutput getCertificate() {
        return this.Certificate;
    }

    /**
     * 设置监听器绑定的证书信息
     * @param Certificate 监听器绑定的证书信息
     */
    public void setCertificate(CertificateOutput Certificate) {
        this.Certificate = Certificate;
    }

    /**
     * 获取监听器的健康检查信息
     * @return HealthCheck 监听器的健康检查信息
     */
    public HealthCheck getHealthCheck() {
        return this.HealthCheck;
    }

    /**
     * 设置监听器的健康检查信息
     * @param HealthCheck 监听器的健康检查信息
     */
    public void setHealthCheck(HealthCheck HealthCheck) {
        this.HealthCheck = HealthCheck;
    }

    /**
     * 获取请求调度方式
     * @return Scheduler 请求调度方式
     */
    public String getScheduler() {
        return this.Scheduler;
    }

    /**
     * 设置请求调度方式
     * @param Scheduler 请求调度方式
     */
    public void setScheduler(String Scheduler) {
        this.Scheduler = Scheduler;
    }

    /**
     * 获取会话保持时间
     * @return SessionExpireTime 会话保持时间
     */
    public Integer getSessionExpireTime() {
        return this.SessionExpireTime;
    }

    /**
     * 设置会话保持时间
     * @param SessionExpireTime 会话保持时间
     */
    public void setSessionExpireTime(Integer SessionExpireTime) {
        this.SessionExpireTime = SessionExpireTime;
    }

    /**
     * 获取是否开启SNI特性（本参数仅对于HTTPS监听器有意义）
     * @return SniSwitch 是否开启SNI特性（本参数仅对于HTTPS监听器有意义）
     */
    public Integer getSniSwitch() {
        return this.SniSwitch;
    }

    /**
     * 设置是否开启SNI特性（本参数仅对于HTTPS监听器有意义）
     * @param SniSwitch 是否开启SNI特性（本参数仅对于HTTPS监听器有意义）
     */
    public void setSniSwitch(Integer SniSwitch) {
        this.SniSwitch = SniSwitch;
    }

    /**
     * 获取监听器下的全部转发规则（本参数仅对于HTTP/HTTPS监听器有意义）
     * @return Rules 监听器下的全部转发规则（本参数仅对于HTTP/HTTPS监听器有意义）
     */
    public RuleOutput [] getRules() {
        return this.Rules;
    }

    /**
     * 设置监听器下的全部转发规则（本参数仅对于HTTP/HTTPS监听器有意义）
     * @param Rules 监听器下的全部转发规则（本参数仅对于HTTP/HTTPS监听器有意义）
     */
    public void setRules(RuleOutput [] Rules) {
        this.Rules = Rules;
    }

    /**
     * 获取监听器的名称
     * @return ListenerName 监听器的名称
     */
    public String getListenerName() {
        return this.ListenerName;
    }

    /**
     * 设置监听器的名称
     * @param ListenerName 监听器的名称
     */
    public void setListenerName(String ListenerName) {
        this.ListenerName = ListenerName;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ListenerId", this.ListenerId);
        this.setParamSimple(map, prefix + "Protocol", this.Protocol);
        this.setParamSimple(map, prefix + "Port", this.Port);
        this.setParamObj(map, prefix + "Certificate.", this.Certificate);
        this.setParamObj(map, prefix + "HealthCheck.", this.HealthCheck);
        this.setParamSimple(map, prefix + "Scheduler", this.Scheduler);
        this.setParamSimple(map, prefix + "SessionExpireTime", this.SessionExpireTime);
        this.setParamSimple(map, prefix + "SniSwitch", this.SniSwitch);
        this.setParamArrayObj(map, prefix + "Rules.", this.Rules);
        this.setParamSimple(map, prefix + "ListenerName", this.ListenerName);

    }
}

