/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.clb.v20180317.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class LoadBalancer  extends AbstractModel{

    /**
    * 负载均衡实例 ID。
    */
    @SerializedName("LoadBalancerId")
    @Expose
    private String LoadBalancerId;

    /**
    * 负载均衡实例的名称。
    */
    @SerializedName("LoadBalancerName")
    @Expose
    private String LoadBalancerName;

    /**
    * 负载均衡实例的网络类型：
OPEN：公网属性， INTERNAL：内网属性。
    */
    @SerializedName("LoadBalancerType")
    @Expose
    private String LoadBalancerType;

    /**
    * 应用型负载均衡标识，1：应用型负载均衡，0：传统型的负载均衡。
    */
    @SerializedName("Forward")
    @Expose
    private Integer Forward;

    /**
    * 负载均衡实例的域名，内网类型负载均衡以及应用型负载均衡实例不提供该字段
    */
    @SerializedName("Domain")
    @Expose
    private String Domain;

    /**
    * 负载均衡实例的 VIP 列表。
    */
    @SerializedName("LoadBalancerVips")
    @Expose
    private String [] LoadBalancerVips;

    /**
    * 负载均衡实例的状态，包括
0：创建中，1：正常运行。
    */
    @SerializedName("Status")
    @Expose
    private Integer Status;

    /**
    * 负载均衡实例的创建时间。
    */
    @SerializedName("CreateTime")
    @Expose
    private String CreateTime;

    /**
    * 负载均衡实例的上次状态转换时间。
    */
    @SerializedName("StatusTime")
    @Expose
    private String StatusTime;

    /**
    * 负载均衡实例所属的项目 ID， 0 表示默认项目。
    */
    @SerializedName("ProjectId")
    @Expose
    private Integer ProjectId;

    /**
    * 私有网络的 ID
    */
    @SerializedName("VpcId")
    @Expose
    private String VpcId;

    /**
    * 高防 LB 的标识，1：高防负载均衡 0：非高防负载均衡。
    */
    @SerializedName("OpenBgp")
    @Expose
    private Integer OpenBgp;

    /**
    * 在 2016 年 12 月份之前的传统型内网负载均衡都是开启了 snat 的。
    */
    @SerializedName("Snat")
    @Expose
    private Boolean Snat;

    /**
    * 0：表示未被隔离，1：表示被隔离。
    */
    @SerializedName("Isolation")
    @Expose
    private Integer Isolation;

    /**
    * 用户开启日志的信息，日志只有公网属性创建了 HTTP 、HTTPS 监听器的负载均衡才会有日志。
    */
    @SerializedName("Log")
    @Expose
    private String Log;

    /**
    * 负载均衡实例所在的子网（仅对内网VPC型LB有意义）
    */
    @SerializedName("SubnetId")
    @Expose
    private String SubnetId;

    /**
     * 获取负载均衡实例 ID。
     * @return LoadBalancerId 负载均衡实例 ID。
     */
    public String getLoadBalancerId() {
        return this.LoadBalancerId;
    }

    /**
     * 设置负载均衡实例 ID。
     * @param LoadBalancerId 负载均衡实例 ID。
     */
    public void setLoadBalancerId(String LoadBalancerId) {
        this.LoadBalancerId = LoadBalancerId;
    }

    /**
     * 获取负载均衡实例的名称。
     * @return LoadBalancerName 负载均衡实例的名称。
     */
    public String getLoadBalancerName() {
        return this.LoadBalancerName;
    }

    /**
     * 设置负载均衡实例的名称。
     * @param LoadBalancerName 负载均衡实例的名称。
     */
    public void setLoadBalancerName(String LoadBalancerName) {
        this.LoadBalancerName = LoadBalancerName;
    }

    /**
     * 获取负载均衡实例的网络类型：
OPEN：公网属性， INTERNAL：内网属性。
     * @return LoadBalancerType 负载均衡实例的网络类型：
OPEN：公网属性， INTERNAL：内网属性。
     */
    public String getLoadBalancerType() {
        return this.LoadBalancerType;
    }

    /**
     * 设置负载均衡实例的网络类型：
OPEN：公网属性， INTERNAL：内网属性。
     * @param LoadBalancerType 负载均衡实例的网络类型：
OPEN：公网属性， INTERNAL：内网属性。
     */
    public void setLoadBalancerType(String LoadBalancerType) {
        this.LoadBalancerType = LoadBalancerType;
    }

    /**
     * 获取应用型负载均衡标识，1：应用型负载均衡，0：传统型的负载均衡。
     * @return Forward 应用型负载均衡标识，1：应用型负载均衡，0：传统型的负载均衡。
     */
    public Integer getForward() {
        return this.Forward;
    }

    /**
     * 设置应用型负载均衡标识，1：应用型负载均衡，0：传统型的负载均衡。
     * @param Forward 应用型负载均衡标识，1：应用型负载均衡，0：传统型的负载均衡。
     */
    public void setForward(Integer Forward) {
        this.Forward = Forward;
    }

    /**
     * 获取负载均衡实例的域名，内网类型负载均衡以及应用型负载均衡实例不提供该字段
     * @return Domain 负载均衡实例的域名，内网类型负载均衡以及应用型负载均衡实例不提供该字段
     */
    public String getDomain() {
        return this.Domain;
    }

    /**
     * 设置负载均衡实例的域名，内网类型负载均衡以及应用型负载均衡实例不提供该字段
     * @param Domain 负载均衡实例的域名，内网类型负载均衡以及应用型负载均衡实例不提供该字段
     */
    public void setDomain(String Domain) {
        this.Domain = Domain;
    }

    /**
     * 获取负载均衡实例的 VIP 列表。
     * @return LoadBalancerVips 负载均衡实例的 VIP 列表。
     */
    public String [] getLoadBalancerVips() {
        return this.LoadBalancerVips;
    }

    /**
     * 设置负载均衡实例的 VIP 列表。
     * @param LoadBalancerVips 负载均衡实例的 VIP 列表。
     */
    public void setLoadBalancerVips(String [] LoadBalancerVips) {
        this.LoadBalancerVips = LoadBalancerVips;
    }

    /**
     * 获取负载均衡实例的状态，包括
0：创建中，1：正常运行。
     * @return Status 负载均衡实例的状态，包括
0：创建中，1：正常运行。
     */
    public Integer getStatus() {
        return this.Status;
    }

    /**
     * 设置负载均衡实例的状态，包括
0：创建中，1：正常运行。
     * @param Status 负载均衡实例的状态，包括
0：创建中，1：正常运行。
     */
    public void setStatus(Integer Status) {
        this.Status = Status;
    }

    /**
     * 获取负载均衡实例的创建时间。
     * @return CreateTime 负载均衡实例的创建时间。
     */
    public String getCreateTime() {
        return this.CreateTime;
    }

    /**
     * 设置负载均衡实例的创建时间。
     * @param CreateTime 负载均衡实例的创建时间。
     */
    public void setCreateTime(String CreateTime) {
        this.CreateTime = CreateTime;
    }

    /**
     * 获取负载均衡实例的上次状态转换时间。
     * @return StatusTime 负载均衡实例的上次状态转换时间。
     */
    public String getStatusTime() {
        return this.StatusTime;
    }

    /**
     * 设置负载均衡实例的上次状态转换时间。
     * @param StatusTime 负载均衡实例的上次状态转换时间。
     */
    public void setStatusTime(String StatusTime) {
        this.StatusTime = StatusTime;
    }

    /**
     * 获取负载均衡实例所属的项目 ID， 0 表示默认项目。
     * @return ProjectId 负载均衡实例所属的项目 ID， 0 表示默认项目。
     */
    public Integer getProjectId() {
        return this.ProjectId;
    }

    /**
     * 设置负载均衡实例所属的项目 ID， 0 表示默认项目。
     * @param ProjectId 负载均衡实例所属的项目 ID， 0 表示默认项目。
     */
    public void setProjectId(Integer ProjectId) {
        this.ProjectId = ProjectId;
    }

    /**
     * 获取私有网络的 ID
     * @return VpcId 私有网络的 ID
     */
    public String getVpcId() {
        return this.VpcId;
    }

    /**
     * 设置私有网络的 ID
     * @param VpcId 私有网络的 ID
     */
    public void setVpcId(String VpcId) {
        this.VpcId = VpcId;
    }

    /**
     * 获取高防 LB 的标识，1：高防负载均衡 0：非高防负载均衡。
     * @return OpenBgp 高防 LB 的标识，1：高防负载均衡 0：非高防负载均衡。
     */
    public Integer getOpenBgp() {
        return this.OpenBgp;
    }

    /**
     * 设置高防 LB 的标识，1：高防负载均衡 0：非高防负载均衡。
     * @param OpenBgp 高防 LB 的标识，1：高防负载均衡 0：非高防负载均衡。
     */
    public void setOpenBgp(Integer OpenBgp) {
        this.OpenBgp = OpenBgp;
    }

    /**
     * 获取在 2016 年 12 月份之前的传统型内网负载均衡都是开启了 snat 的。
     * @return Snat 在 2016 年 12 月份之前的传统型内网负载均衡都是开启了 snat 的。
     */
    public Boolean getSnat() {
        return this.Snat;
    }

    /**
     * 设置在 2016 年 12 月份之前的传统型内网负载均衡都是开启了 snat 的。
     * @param Snat 在 2016 年 12 月份之前的传统型内网负载均衡都是开启了 snat 的。
     */
    public void setSnat(Boolean Snat) {
        this.Snat = Snat;
    }

    /**
     * 获取0：表示未被隔离，1：表示被隔离。
     * @return Isolation 0：表示未被隔离，1：表示被隔离。
     */
    public Integer getIsolation() {
        return this.Isolation;
    }

    /**
     * 设置0：表示未被隔离，1：表示被隔离。
     * @param Isolation 0：表示未被隔离，1：表示被隔离。
     */
    public void setIsolation(Integer Isolation) {
        this.Isolation = Isolation;
    }

    /**
     * 获取用户开启日志的信息，日志只有公网属性创建了 HTTP 、HTTPS 监听器的负载均衡才会有日志。
     * @return Log 用户开启日志的信息，日志只有公网属性创建了 HTTP 、HTTPS 监听器的负载均衡才会有日志。
     */
    public String getLog() {
        return this.Log;
    }

    /**
     * 设置用户开启日志的信息，日志只有公网属性创建了 HTTP 、HTTPS 监听器的负载均衡才会有日志。
     * @param Log 用户开启日志的信息，日志只有公网属性创建了 HTTP 、HTTPS 监听器的负载均衡才会有日志。
     */
    public void setLog(String Log) {
        this.Log = Log;
    }

    /**
     * 获取负载均衡实例所在的子网（仅对内网VPC型LB有意义）
     * @return SubnetId 负载均衡实例所在的子网（仅对内网VPC型LB有意义）
     */
    public String getSubnetId() {
        return this.SubnetId;
    }

    /**
     * 设置负载均衡实例所在的子网（仅对内网VPC型LB有意义）
     * @param SubnetId 负载均衡实例所在的子网（仅对内网VPC型LB有意义）
     */
    public void setSubnetId(String SubnetId) {
        this.SubnetId = SubnetId;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "LoadBalancerId", this.LoadBalancerId);
        this.setParamSimple(map, prefix + "LoadBalancerName", this.LoadBalancerName);
        this.setParamSimple(map, prefix + "LoadBalancerType", this.LoadBalancerType);
        this.setParamSimple(map, prefix + "Forward", this.Forward);
        this.setParamSimple(map, prefix + "Domain", this.Domain);
        this.setParamArraySimple(map, prefix + "LoadBalancerVips.", this.LoadBalancerVips);
        this.setParamSimple(map, prefix + "Status", this.Status);
        this.setParamSimple(map, prefix + "CreateTime", this.CreateTime);
        this.setParamSimple(map, prefix + "StatusTime", this.StatusTime);
        this.setParamSimple(map, prefix + "ProjectId", this.ProjectId);
        this.setParamSimple(map, prefix + "VpcId", this.VpcId);
        this.setParamSimple(map, prefix + "OpenBgp", this.OpenBgp);
        this.setParamSimple(map, prefix + "Snat", this.Snat);
        this.setParamSimple(map, prefix + "Isolation", this.Isolation);
        this.setParamSimple(map, prefix + "Log", this.Log);
        this.setParamSimple(map, prefix + "SubnetId", this.SubnetId);

    }
}

