/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tmt.v20180321.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class LanguageDetectRequest  extends AbstractModel{

    /**
    * 待识别的文本，文本统一使用utf-8格式编码，非utf-8格式编码字符会翻译失败
    */
    @SerializedName("Text")
    @Expose
    private String Text;

    /**
    * 项目id
    */
    @SerializedName("ProjectId")
    @Expose
    private Integer ProjectId;

    /**
     * 获取待识别的文本，文本统一使用utf-8格式编码，非utf-8格式编码字符会翻译失败
     * @return Text 待识别的文本，文本统一使用utf-8格式编码，非utf-8格式编码字符会翻译失败
     */
    public String getText() {
        return this.Text;
    }

    /**
     * 设置待识别的文本，文本统一使用utf-8格式编码，非utf-8格式编码字符会翻译失败
     * @param Text 待识别的文本，文本统一使用utf-8格式编码，非utf-8格式编码字符会翻译失败
     */
    public void setText(String Text) {
        this.Text = Text;
    }

    /**
     * 获取项目id
     * @return ProjectId 项目id
     */
    public Integer getProjectId() {
        return this.ProjectId;
    }

    /**
     * 设置项目id
     * @param ProjectId 项目id
     */
    public void setProjectId(Integer ProjectId) {
        this.ProjectId = ProjectId;
    }

    /**
     * 内部实现，用户禁止调用
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Text", this.Text);
        this.setParamSimple(map, prefix + "ProjectId", this.ProjectId);

    }
}

