/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class DruidDSFactory
extends DSFactory {
    public static final String DS_NAME = "Druid";
    private Map<String, DruidDataSource> dsMap = new ConcurrentHashMap<String, DruidDataSource>();

    public DruidDSFactory() {
        this(null);
    }

    public DruidDSFactory(Setting setting) {
        super(DS_NAME, DruidDataSource.class, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        DruidDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DruidDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        DruidDataSource dds;
        if (group == null) {
            group = "";
        }
        if ((dds = this.dsMap.get(group)) != null) {
            IoUtil.close((Closeable)dds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<DruidDataSource> values = this.dsMap.values();
            for (DruidDataSource dds : values) {
                IoUtil.close((Closeable)dds);
            }
            this.dsMap.clear();
        }
    }

    private DruidDataSource createDataSource(String group) {
        Properties config = this.setting.getProperties(group);
        if (CollectionUtil.isEmpty(config)) {
            throw new DbRuntimeException("No Druid config for group: [{}]", group);
        }
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(this.getAndRemoveProperty(config, "url", "jdbcUrl"));
        ds.setUsername(this.getAndRemoveProperty(config, "username", "user"));
        ds.setPassword(this.getAndRemoveProperty(config, "password", "pass"));
        String driver = this.getAndRemoveProperty(config, "driver", "driverClassName");
        if (StrUtil.isNotBlank(driver)) {
            ds.setDriverClassName(driver);
        }
        Properties config2 = new Properties();
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            String keyStr = StrUtil.addPrefixIfNot(Convert.toStr(entry.getKey()), "druid.");
            config2.put(keyStr, entry.getValue());
        }
        ds.configFromPropety(config2);
        if (null == ds.getValidationQuery()) {
            ds.setTestOnBorrow(false);
            ds.setTestOnReturn(false);
            ds.setTestWhileIdle(false);
        }
        return ds;
    }

    private String getAndRemoveProperty(Properties properties, String key1, String key2) {
        String value = (String)properties.remove(key1);
        if (StrUtil.isBlank(value)) {
            value = (String)properties.remove(key2);
        }
        return value;
    }
}

