/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.export.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import net.biville.florent.sproccompiler.export.Either;
import net.biville.florent.sproccompiler.export.io.DsvFieldSerializers;
import net.biville.florent.sproccompiler.export.messages.DsvExportError;

public class DsvFieldExporter {
    private final DsvFieldSerializers serializers;

    public DsvFieldExporter(Elements elementUtils) {
        this.serializers = new DsvFieldSerializers(elementUtils);
    }

    public Either<DsvExportError, List<String>> exportHeaders(String delimiter, String headerInput) {
        String inputOption = headerInput.trim();
        List<String> allFields = this.serializers.getAllFields();
        if (inputOption.equals("*")) {
            return Either.right(allFields);
        }
        List<String> result = this.sanitize(delimiter, inputOption);
        return this.validateHeaders(delimiter, allFields, result);
    }

    public Stream<Either<DsvExportError, String>> exportFields(ExecutableElement method, Collection<String> exportedHeaders) {
        return exportedHeaders.stream().map(f -> this.serializers.serializeField(method, (String)f));
    }

    private List<String> sanitize(String delimiter, String inputOption) {
        return Arrays.stream(inputOption.split(String.format("\\Q%s\\E", delimiter))).map(String::trim).distinct().collect(Collectors.toList());
    }

    private Either<DsvExportError, List<String>> validateHeaders(String delimiter, List<String> allFields, List<String> result) {
        List<String> faultyHeaders = this.validate(allFields, result);
        if (faultyHeaders.isEmpty()) {
            return Either.right(result);
        }
        return Either.left(new DsvExportError(null, "%nExported delimiter-separated header contains invalid values: %s. %n\tDelimiter should be: %s %n\tValid values are '*' or any subset of '%s'", faultyHeaders, delimiter, String.join((CharSequence)delimiter, allFields)));
    }

    private List<String> validate(List<String> allFields, List<String> result) {
        return result.stream().filter(t -> !allFields.contains(t)).collect(Collectors.toList());
    }
}

