/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.visitors;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import net.biville.florent.sproccompiler.messages.CompilationMessage;
import net.biville.florent.sproccompiler.messages.ContextFieldWarning;
import net.biville.florent.sproccompiler.messages.FieldError;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;

class ContextFieldVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    private static final Set<Class<?>> SUPPORTED_TYPES = new LinkedHashSet<Class>(Arrays.asList(GraphDatabaseService.class, Log.class));
    private final Elements elements;
    private final Types types;
    private final boolean skipContextWarnings;

    public ContextFieldVisitor(Types types, Elements elements, boolean skipContextWarnings) {
        this.elements = elements;
        this.types = types;
        this.skipContextWarnings = skipContextWarnings;
    }

    private static String types(Set<Class<?>> supportedTypes) {
        return supportedTypes.stream().map(Class::getName).collect(Collectors.joining(">, <", "<", ">"));
    }

    @Override
    public Stream<CompilationMessage> visitVariable(VariableElement field, Void ignored) {
        return Stream.concat(this.validateModifiers(field), this.validateInjectedTypes(field));
    }

    private Stream<CompilationMessage> validateModifiers(VariableElement field) {
        if (!this.hasValidModifiers(field)) {
            return Stream.of(new FieldError(field, "@%s usage error: field %s#%s should be public, non-static and non-final", Context.class.getName(), field.getEnclosingElement().getSimpleName(), field.getSimpleName()));
        }
        return Stream.empty();
    }

    private Stream<CompilationMessage> validateInjectedTypes(VariableElement field) {
        if (this.skipContextWarnings) {
            return Stream.empty();
        }
        TypeMirror fieldType = field.asType();
        if (!this.injectsAllowedTypes(fieldType)) {
            return Stream.of(new ContextFieldWarning(field, "@%s usage warning: found type: <%s>, expected one of: %s", Context.class.getName(), fieldType.toString(), ContextFieldVisitor.types(SUPPORTED_TYPES)));
        }
        return Stream.empty();
    }

    private boolean injectsAllowedTypes(TypeMirror fieldType) {
        return this.supportedTypeMirrors(SUPPORTED_TYPES).filter(t -> this.types.isSameType((TypeMirror)t, fieldType)).findAny().isPresent();
    }

    private boolean hasValidModifiers(VariableElement field) {
        Set<Modifier> modifiers = field.getModifiers();
        return modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.FINAL);
    }

    private Stream<TypeMirror> supportedTypeMirrors(Set<Class<?>> supportedTypes) {
        return supportedTypes.stream().map(c -> this.elements.getTypeElement(c.getName()).asType());
    }
}

