/*
 * Decompiled with CFR 0.152.
 */
package net.parim.pay.sdk.util.sign;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.parim.pay.sdk.exception.PayException;
import net.parim.pay.sdk.util.StringUtils;
import net.parim.pay.sdk.util.encrypt.MD5;
import net.parim.pay.sdk.util.encrypt.RSA;
import net.parim.pay.sdk.util.encrypt.RSA2;
import net.parim.pay.sdk.util.encrypt.SHA1;
import net.parim.pay.sdk.util.encrypt.SHA256;
import net.parim.pay.sdk.util.encrypt.SignType;
import org.apache.http.message.BasicNameValuePair;

public enum SignUtils implements SignType
{
    MD5{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.MD5.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String key, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.MD5.verify(text, sign, key, characterEncoding);
        }
    }
    ,
    HMACSHA256{

        @Override
        public String getName() {
            return "HMAC-SHA256";
        }

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            Mac sha256HMAC = null;
            try {
                sha256HMAC = Mac.getInstance("HmacSHA256");
                SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(characterEncoding), "HmacSHA256");
                sha256HMAC.init(secretKey);
                byte[] array = sha256HMAC.doFinal(content.getBytes(characterEncoding));
                StringBuilder sb = new StringBuilder();
                for (byte item : array) {
                    sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
                }
                return sb.toString().toUpperCase();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            throw new PayException("HMACSHA256 \u7edb\u60e7\u6095\u5bee\u509a\u7236");
        }

        @Override
        public boolean verify(String text, String sign, String key, String characterEncoding) {
            return this.createSign(text, key, characterEncoding).equals(sign);
        }
    }
    ,
    RSA{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.RSA.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String publicKey, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.RSA.verify(text, sign, publicKey, characterEncoding);
        }
    }
    ,
    RSA2{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.RSA2.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String publicKey, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.RSA2.verify(text, sign, publicKey, characterEncoding);
        }
    }
    ,
    SHA1{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.SHA1.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String publicKey, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.SHA1.verify(text, sign, publicKey, characterEncoding);
        }
    }
    ,
    SHA256{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.SHA256.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String publicKey, String characterEncoding) {
            return net.parim.pay.sdk.util.encrypt.SHA256.verify(text, sign, publicKey, characterEncoding);
        }
    };


    public static String parameterText(Map parameters) {
        return SignUtils.parameterText(parameters, "&");
    }

    public static String parameterText(Map parameters, String separator) {
        return SignUtils.parameterText(parameters, separator, "signature", "sign", "key", "sign_type");
    }

    public static String parameterText(Map parameters, String separator, String ... ignoreKey) {
        return SignUtils.parameterText(parameters, separator, true, ignoreKey);
    }

    public static String parameterText(Map parameters, String separator, boolean ignoreNullValue, String ... ignoreKey) {
        if (parameters == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (null != ignoreKey) {
            Arrays.sort(ignoreKey);
        }
        if (parameters instanceof SortedMap) {
            for (Map.Entry entry : parameters.entrySet()) {
                Object v = entry.getValue();
                if (null == v || "".equals(v.toString().trim()) || null != ignoreKey && Arrays.binarySearch(ignoreKey, entry.getKey()) >= 0) continue;
                sb.append((String)entry.getKey()).append("=").append(v.toString().trim()).append(separator);
            }
            if (sb.length() > 0 && !"".equals(separator)) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        ArrayList keys = new ArrayList(parameters.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            String valueStr = "";
            Object o = parameters.get(k);
            if (ignoreNullValue && null == o) continue;
            if (o instanceof String[]) {
                String[] values = (String[])o;
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i].trim();
                    if ("".equals(value)) continue;
                    valueStr = valueStr + (i == values.length - 1 ? value : value + ",");
                }
            } else {
                valueStr = o.toString();
            }
            if (null == valueStr || "".equals(valueStr.toString().trim()) || null != ignoreKey && Arrays.binarySearch(ignoreKey, k) >= 0) continue;
            sb.append(k).append("=").append(valueStr).append(separator);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String parameters2MD5Str(Object parameters, String separator) {
        StringBuffer sb;
        block3: {
            block2: {
                sb = new StringBuffer();
                if (!(parameters instanceof LinkedHashMap)) break block2;
                Set keys = ((LinkedHashMap)parameters).keySet();
                for (String key : keys) {
                    String val = ((LinkedHashMap)parameters).get(key).toString();
                    sb.append(val).append(separator);
                }
                break block3;
            }
            if (!(parameters instanceof List)) break block3;
            for (BasicNameValuePair bnv : (List)parameters) {
                sb.append(bnv.getValue()).append(separator);
            }
        }
        return StringUtils.isBlank(sb.toString()) ? "" : sb.deleteCharAt(sb.length() - 1).toString();
    }

    public static String randomStr() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String sign(Map parameters, String key, String characterEncoding) {
        return this.createSign(SignUtils.parameterText(parameters, "&"), key, characterEncoding);
    }

    @Override
    public String sign(Map parameters, String key, String separator, String characterEncoding) {
        return this.createSign(SignUtils.parameterText(parameters, separator), key, characterEncoding);
    }

    @Override
    public boolean verify(Map params, String sign, String key, String characterEncoding) {
        return this.verify(SignUtils.parameterText(params), sign, key, characterEncoding);
    }
}

