/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.config;

import net.qimooc.commons.config.CookieProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
@EnableRedisHttpSession
public class CookieConfig {
    public CookieSerializer defaultCookieSerializer(CookieProperties cookieProperties) {
        DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
        if (cookieProperties != null) {
            if (cookieProperties.getPath() != null) {
                cookieSerializer.setCookiePath(cookieProperties.getPath());
            }
            if (cookieProperties.getDomain() != null) {
                cookieSerializer.setDomainName(cookieProperties.getDomain());
            }
            if (cookieProperties.getMaxAge() != null) {
                cookieSerializer.setCookieMaxAge(cookieProperties.getMaxAge().intValue());
            }
            if (cookieProperties.getName() != null) {
                cookieSerializer.setCookieName(cookieProperties.getName());
            }
            if (cookieProperties.getHttpOnly() != null) {
                cookieSerializer.setUseHttpOnlyCookie(cookieProperties.getHttpOnly().booleanValue());
            }
            if (cookieProperties.getSecure() != null) {
                cookieSerializer.setUseSecureCookie(cookieProperties.getSecure().booleanValue());
            }
        }
        return cookieSerializer;
    }
}

