/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class DefaultJsonSerializer
extends JsonSerializer<String> {
    public void serialize(String objectValue, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (StringUtils.isEmpty((CharSequence)objectValue)) {
            objectValue = "";
        }
        Whitelist.none();
        Whitelist whitelist = Whitelist.relaxed();
        this.getWhitelist(whitelist);
        Cleaner cleaner = new Cleaner(whitelist);
        objectValue = this.unescapeUntilNoHtmlEntityFound(objectValue, cleaner);
        jsonGenerator.writeString(objectValue);
    }

    public String unescapeUntilNoHtmlEntityFound(String value, Cleaner cleaner) {
        Document cleanedDocument = cleaner.clean(Jsoup.parse((String)value));
        cleanedDocument.outputSettings().prettyPrint(false).escapeMode(Entities.EscapeMode.xhtml).charset(StandardCharsets.UTF_8);
        String unescaped = Parser.unescapeEntities((String)cleanedDocument.body().html().trim(), (boolean)true);
        if (!unescaped.equals(value)) {
            return this.unescapeUntilNoHtmlEntityFound(unescaped, cleaner);
        }
        return unescaped;
    }

    public Whitelist getWhitelist(Whitelist whitelist) {
        return whitelist.addTags(new String[]{"svg", "s"}).addAttributes(":all", new String[]{"style", "class"}).removeProtocols("img", "src", new String[]{"http", "https"});
    }

    public Class<String> handledType() {
        return String.class;
    }
}

