/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.service;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.qimooc.commons.entity.Repairable;
import net.qimooc.commons.query.builder.LofterQueryPredicateBuilder;
import net.qimooc.commons.repository.SupportRepository;
import net.qimooc.commons.service.CrudService;
import net.qimooc.commons.service.DataRuleService;
import net.qimooc.commons.service.DataRuleWapper;
import net.qimooc.commons.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.transaction.annotation.Transactional;

public class BaseService<T, ID extends Serializable, R extends SupportRepository<T, ID>>
implements CrudService<T, ID>,
DataRuleService<T, Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(BaseService.class);
    private Class<T> clazz;
    protected R repository;
    protected boolean isReparable = false;
    protected DataRuleWapper dataRuleWapper;

    public BaseService() {
        Class clazz;
        this.clazz = clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.isReparable = Repairable.class.isAssignableFrom(clazz);
    }

    @Autowired
    public <S extends R> void setRepository(S repository) {
        this.repository = repository;
    }

    @Autowired(required=false)
    public void setDataRuleWapper(DataRuleWapper dataRuleWapper) {
        this.dataRuleWapper = dataRuleWapper;
    }

    @Override
    @Transactional
    public <S extends T> S save(S entity) {
        return (S)this.repository.saveAndFlush(entity);
    }

    @Override
    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        return this.repository.saveAll(entities);
    }

    @Override
    public T findOne(ID id) {
        return this.repository.findById(id).orElse(null);
    }

    @Override
    public T getOne(ID id) {
        return (T)this.repository.getOne(id);
    }

    @Override
    public boolean exists(ID id) {
        return this.repository.existsById(id);
    }

    @Override
    public Iterable<T> findAll() {
        return this.repository.findAll();
    }

    @Override
    public Iterable<T> findAll(Iterable<ID> ids) {
        return this.repository.findAllById(ids);
    }

    @Override
    public long count() {
        return this.repository.count();
    }

    @Override
    public void delete(ID id) {
        this.delete((T)id, false);
    }

    @Override
    public void delete(List<ID> ids) {
        for (Serializable id : ids) {
            this.delete((T)id, false);
        }
    }

    @Override
    public void delete(ID[] ids) {
        this.delete((T)Arrays.asList(ids), false);
    }

    @Override
    public void delete(T entity) {
        this.delete(entity, false);
    }

    @Override
    public void delete(Iterable<? extends T> entities) {
        this.delete(entities, false);
    }

    @Override
    public void deleteAll() {
        this.deleteAll(false);
    }

    @Override
    public <S extends T> Iterable<S> findAll(Example<S> example) {
        Repairable e;
        if (this.isReparable && (e = (Repairable)example.getProbe()).getIsDeleted() == null) {
            e.setIsDeleted(false);
        }
        return this.repository.findAll(example);
    }

    @Override
    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Repairable e;
        if (this.isReparable && (e = (Repairable)example.getProbe()).getIsDeleted() == null) {
            e.setIsDeleted(false);
        }
        return this.repository.findAll(Example.of((Object)example.getProbe()), pageable);
    }

    @Override
    public List<T> findAll(T entity) {
        return this.repository.findAll(this.handleQueryAnnotation(entity));
    }

    @Override
    public Page<T> findAll(T entity, Pageable pageable) {
        return this.repository.findAll(this.handleQueryAnnotation(entity), pageable);
    }

    @Override
    public List<T> findAll(T entity, ExampleMatcher matcher) {
        return this.repository.findAll(this.handleQueryAnnotation(entity, matcher));
    }

    @Override
    public Page<T> findAll(T entity, ExampleMatcher matcher, Pageable pageable) {
        return this.repository.findAll(this.handleQueryAnnotation(entity, matcher), pageable);
    }

    @Override
    public List<T> findAllWithDataRule(T entity) {
        return this.repository.findAll(this.withDataRule(this.handleQueryAnnotation(entity)));
    }

    @Override
    public Page<T> findAllWithDataRule(T entity, Pageable pageable) {
        return this.repository.findAll(this.withDataRule(this.handleQueryAnnotation(entity)), pageable);
    }

    @Override
    public List<T> findAllWithDataRule(T entity, ExampleMatcher matcher) {
        return this.repository.findAll(this.withDataRule(this.handleQueryAnnotation(entity, matcher)));
    }

    @Override
    public Page<T> findAllWithDataRule(T entity, ExampleMatcher matcher, Pageable pageable) {
        return this.repository.findAll(this.withDataRule(this.handleQueryAnnotation(entity, matcher)), pageable);
    }

    @Override
    public void delete(ID id, boolean isPhysical) {
        if (!this.checkDeleteable(id)) {
            return;
        }
        if (this.isReparable && !isPhysical) {
            this.tagDelete((T)id);
        } else {
            this.repository.deleteById(id);
        }
    }

    @Override
    public void delete(List<ID> ids, boolean isPhysical) {
        for (Serializable id : ids) {
            this.delete((T)id, isPhysical);
        }
    }

    @Override
    public void delete(ID[] ids, boolean isPhysical) {
        this.delete((T)Arrays.asList(ids), isPhysical);
    }

    @Override
    public void delete(T entity, boolean isPhysical) {
        if (!this.checkDeleteable((ID)entity)) {
            return;
        }
        if (this.isReparable && !isPhysical) {
            this.tagDelete(entity);
        } else {
            this.repository.delete(entity);
        }
    }

    @Override
    public void delete(Iterable<? extends T> entities, boolean isPhysical) {
        for (T entity : entities) {
            if (this.checkDeleteable((ID)entity)) continue;
            return;
        }
        if (this.isReparable && !isPhysical) {
            for (T entity : entities) {
                this.tagDelete(entity);
            }
        } else {
            this.repository.deleteAll(entities);
        }
    }

    @Override
    public void deleteAll(boolean isPhysical) {
        if (this.isReparable && !isPhysical) {
            throw new RuntimeException("The Reparable class cannot be tag delete all");
        }
        this.repository.deleteAll();
    }

    protected void tagDelete(ID id) {
        T entity = this.findOne(id);
        this.tagDelete(entity);
    }

    protected void tagDelete(T entity) {
        if (null == entity) {
            return;
        }
        if (this.isReparable) {
            try {
                ((Repairable)entity).setIsDeleted(true);
                this.save(entity);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("The given class " + entity.getClass() + " is not a Repairable(" + Repairable.class + ") class");
            }
        } else {
            throw new RuntimeException("The given class " + entity.getClass() + " is not a Repairable(" + Repairable.class + ") class");
        }
    }

    protected boolean checkDeleteable(T entity) {
        return true;
    }

    protected boolean checkDeleteable(ID id) {
        return true;
    }

    @Override
    public T update(ID id, T entity) {
        T entity2 = this.findOne(id);
        try {
            new BeanUtils().copyProperties(entity2, entity, true);
            entity2 = this.save(entity2);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return entity2;
    }

    @Override
    public Specification<T> withDataRule(Specification<T> specification) {
        if (null != this.dataRuleWapper) {
            Specification specifications = Specification.where(specification).and(this.dataRuleWapper.getDataRuleSpecification(this.clazz));
            return specifications;
        }
        logger.warn("DataRuleWapper not been providored.");
        return specification;
    }

    @Override
    public Specification<T> handleQueryAnnotation(final T entity) {
        if (entity == null) {
            return null;
        }
        final Boolean isReparable = this.isReparable;
        return new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                ArrayList predicates = Lists.newArrayList();
                if (isReparable.booleanValue()) {
                    Predicate isDeletePredicate = builder.equal((Expression)root.get("isDeleted"), (Object)false);
                    predicates.add(isDeletePredicate);
                }
                predicates.add(LofterQueryPredicateBuilder.getPredicate(root, builder, entity));
                Predicate[] p = new Predicate[predicates.size()];
                return builder.and(predicates.toArray(p));
            }
        };
    }

    @Override
    public Specification<T> handleQueryAnnotation(final T entity, final ExampleMatcher matcher) {
        if (entity == null) {
            return null;
        }
        final Boolean isReparable = this.isReparable;
        return new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                ArrayList predicates = Lists.newArrayList();
                if (isReparable.booleanValue()) {
                    Predicate isDeletePredicate = builder.equal((Expression)root.get("isDeleted"), (Object)false);
                    predicates.add(isDeletePredicate);
                }
                predicates.add(LofterQueryPredicateBuilder.getPredicate(root, builder, entity, matcher));
                Predicate[] p = new Predicate[predicates.size()];
                return builder.and(predicates.toArray(p));
            }
        };
    }

    @Override
    public List<T> findAllWithDataRule(Specification<T> specification) {
        return this.findAll(this.withDataRule(specification));
    }

    @Override
    public Page<T> findAllWithDataRule(Specification<T> specification, Pageable pageable) {
        return this.findAll(this.withDataRule(specification), pageable);
    }

    @Override
    public T findOne(Specification<T> spec) {
        return this.repository.findOne(spec).orElse(null);
    }

    @Override
    public List<T> findAll(Specification<T> spec) {
        return this.repository.findAll(spec);
    }

    @Override
    public Page<T> findAll(Specification<T> spec, Pageable pageable) {
        return this.repository.findAll(spec, pageable);
    }

    @Override
    public List<T> findAll(Specification<T> spec, Sort sort) {
        return this.repository.findAll(spec, sort);
    }

    @Override
    public long count(Specification<T> spec) {
        return this.repository.count(spec);
    }
}

