/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.spring.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.qimooc.commons.spring.aop.MethodInterceptorParamContext;
import net.qimooc.commons.utils.AopUtils;
import net.qimooc.commons.utils.ThreadLocalUtils;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.DigestUtils;

public class MethodInterceptorHolder {
    public static final ParameterNameDiscoverer nameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private String id;
    private Method method;
    private Object target;
    private Map<String, Object> args;

    public static MethodInterceptorHolder current() {
        return (MethodInterceptorHolder)ThreadLocalUtils.get(MethodInterceptorHolder.class.getName());
    }

    public static MethodInterceptorHolder clear() {
        return (MethodInterceptorHolder)ThreadLocalUtils.getAndRemove(MethodInterceptorHolder.class.getName());
    }

    public static MethodInterceptorHolder setCurrent(MethodInterceptorHolder holder) {
        return ThreadLocalUtils.put(MethodInterceptorHolder.class.getName(), holder);
    }

    public static MethodInterceptorHolder create(MethodInvocation invocation) {
        String id = DigestUtils.md5DigestAsHex((byte[])String.valueOf(invocation.getMethod().hashCode()).getBytes());
        String[] argNames = nameDiscoverer.getParameterNames(invocation.getMethod());
        Object[] args = invocation.getArguments();
        LinkedHashMap<String, Object> argMap = new LinkedHashMap<String, Object>();
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            argMap.put(argNames[i] == null ? "arg" + i : argNames[i], args[i]);
        }
        return new MethodInterceptorHolder(id, invocation.getMethod(), invocation.getThis(), argMap);
    }

    public MethodInterceptorHolder set() {
        MethodInterceptorHolder.setCurrent(this);
        return this;
    }

    public MethodInterceptorHolder(String id, Method method, Object target, Map<String, Object> args) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(id);
        Objects.requireNonNull(method);
        Objects.requireNonNull(target);
        Objects.requireNonNull(args);
        this.id = id;
        this.method = method;
        this.target = target;
        this.args = args;
    }

    public String getId() {
        return this.id;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public <T extends Annotation> T findMethodAnnotation(Class<T> annClass) {
        return AopUtils.findMethodAnnotation(annClass, this.method, annClass);
    }

    public <T extends Annotation> T findClassAnnotation(Class<T> annClass) {
        return AopUtils.findAnnotation(this.target.getClass(), annClass);
    }

    public <T extends Annotation> T findAnnotation(Class<T> annClass) {
        return AopUtils.findAnnotation(this.target.getClass(), this.method, annClass);
    }

    public MethodInterceptorParamContext createParamContext() {
        return new MethodInterceptorParamContext(){

            @Override
            public Object getTarget() {
                return MethodInterceptorHolder.this.target;
            }

            @Override
            public Method getMethod() {
                return MethodInterceptorHolder.this.method;
            }

            @Override
            public <T> Optional<T> getParameter(String name) {
                if (MethodInterceptorHolder.this.args == null) {
                    return Optional.empty();
                }
                return Optional.of(MethodInterceptorHolder.this.args.get(name));
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annClass) {
                return MethodInterceptorHolder.this.findAnnotation(annClass);
            }

            @Override
            public Map<String, Object> getParams() {
                return MethodInterceptorHolder.this.getArgs();
            }
        };
    }
}

