/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.spring.aop;

import java.lang.reflect.Method;
import net.qimooc.commons.utils.ThreadLocalUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Aspect
@Component
public class TypeMapNameAspect {
    private static final Logger logger = LoggerFactory.getLogger(TypeMapNameAspect.class);

    @Pointcut(value="execution(public * net.parim..controller..*.*(..))")
    public void controller() {
    }

    @Before(value="controller()")
    public void doBefore(JoinPoint joinPoint) {
        if (logger.isInfoEnabled()) {
            // empty if block
        }
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        try {
            Method realMethod = joinPoint.getTarget().getClass().getDeclaredMethod(signature.getName(), targetMethod.getParameterTypes());
            if (realMethod.isAnnotationPresent(RequestMapping.class) || realMethod.isAnnotationPresent(GetMapping.class) || realMethod.isAnnotationPresent(PostMapping.class) || realMethod.isAnnotationPresent(PutMapping.class) || realMethod.isAnnotationPresent(DeleteMapping.class)) {
                ThreadLocalUtils.put("typeMappingName", joinPoint.getTarget().getClass().getSimpleName() + "_" + joinPoint.getSignature().getName());
            }
        }
        catch (NoSuchMethodException e) {
            logger.error("typeMappingName Error", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("typeMappingName Error", (Throwable)e);
        }
    }

    @After(value="controller()")
    public void doAfter() {
        if (logger.isInfoEnabled()) {
            logger.info("After");
        }
    }

    @AfterReturning(returning="object", pointcut="controller()")
    public void doAfterReturing(Object object) {
        if (logger.isInfoEnabled()) {
            logger.info("return={}", object);
        }
    }
}

