/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.qimooc.commons.i18n.LocaleMessageSourceService;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

@ControllerAdvice
public class GlobalExceptionHandler
extends ExceptionHandlerExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Autowired
    LocaleMessageSourceService localeMessageSourceService;

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public String IllegalArgumentExceptionHandler(HttpServletRequest request, Exception ex) throws JsonProcessingException {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("timestamp", System.currentTimeMillis());
        resp.put("status", 500);
        resp.put("error", "Internal Server Error");
        resp.put("message", StringEscapeUtils.escapeHtml4((String)this.localeMessageSourceService.getMessage(ex.getMessage(), ex.getMessage())));
        resp.put("url", request.getRequestURL());
        return Jackson2ObjectMapperBuilder.json().build().writeValueAsString(resp);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={BadSqlGrammarException.class})
    @ResponseBody
    public Object BadSqlGrammarExceptionExceptionHandler(HttpServletRequest request, Exception ex) throws JsonProcessingException {
        logger.error(ex.getMessage(), (Throwable)ex);
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("timestamp", System.currentTimeMillis());
        resp.put("status", 500);
        resp.put("error", "Internal Server Error");
        resp.put("message", this.localeMessageSourceService.getMessage("common.jdbc.bad-sql-grammar-exception"));
        resp.put("url", request.getRequestURL());
        return Jackson2ObjectMapperBuilder.json().build().writeValueAsString(resp);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    public Object ValidationBindExceptionHandler(HttpServletRequest request, BindException ex) throws JsonProcessingException {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        this.getValidationExceptionHandlerResult(request, resp, (Exception)ex);
        return Jackson2ObjectMapperBuilder.json().build().writeValueAsString(resp);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public Object MethodArgumentNotValidExceptionHandler(HttpServletRequest request, MethodArgumentNotValidException ex) throws JsonProcessingException {
        HashMap<String, Object> resp = new HashMap<String, Object>();
        this.getValidationExceptionHandlerResult(request, resp, (Exception)ex);
        return Jackson2ObjectMapperBuilder.json().build().writeValueAsString(resp);
    }

    private void getValidationExceptionHandlerResult(HttpServletRequest request, Map<String, Object> resp, Exception ex) {
        resp.put("timestamp", System.currentTimeMillis());
        resp.put("status", 500);
        resp.put("error", "Internal Server Error");
        logger.error(ex.getMessage(), (Throwable)ex);
        BindingResult bindingResult = null;
        if (ex.getClass().equals(MethodArgumentNotValidException.class)) {
            bindingResult = ((MethodArgumentNotValidException)ex).getBindingResult();
        } else if (ex.getClass().equals(BindException.class)) {
            bindingResult = ((BindException)ex).getBindingResult();
        }
        if (bindingResult != null) {
            List allerrors = bindingResult.getAllErrors();
            HashSet<String> errorMessage = new HashSet<String>();
            for (ObjectError error : allerrors) {
                errorMessage.add(this.localeMessageSourceService.getMessage(error.getDefaultMessage()));
            }
            resp.put("message", StringUtils.join(errorMessage, (String)","));
        } else {
            resp.put("message", ex.getMessage());
        }
        resp.put("url", request.getRequestURL());
    }
}

