/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ApiOriginFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse resp = (HttpServletResponse)response;
        HttpServletRequest resq = (HttpServletRequest)request;
        String origin = resq.getHeader("Origin");
        String requestHeaders = resq.getHeader("Access-Control-Request-Headers");
        resp.addHeader("Access-Control-Allow-Credentials", "true");
        resp.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT, OPTIONS");
        if (origin != null) {
            resp.addHeader("Access-Control-Allow-Origin", origin);
        }
        if (StringUtils.isNotEmpty((CharSequence)requestHeaders)) {
            resp.addHeader("Access-Control-Allow-Headers", requestHeaders);
        }
        if (((HttpServletRequest)request).getMethod().equals("OPTIONS")) {
            resp.setStatus(202);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }
}

