/*
 * Decompiled with CFR 0.152.
 */
package net.qimooc.commons.web.resubmit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.qimooc.commons.web.resubmit.ResubmitException;
import net.qimooc.commons.web.resubmit.ResubmitStopper;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ResubmitAdapter
extends HandlerInterceptorAdapter {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            MethodParameter[] methodParameters;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            for (MethodParameter methodParameter : methodParameters = handlerMethod.getMethodParameters()) {
                if (!methodParameter.hasParameterAnnotation(RequestBody.class)) continue;
                return super.preHandle(request, response, handler);
            }
            Method method = handlerMethod.getMethod();
            ResubmitStopper stoper = method.getAnnotation(ResubmitStopper.class);
            if (stoper != null) {
                boolean enable = stoper.enable();
                RequestMethod[] methods = stoper.method();
                if (enable && this.isResubmit(request, methods)) {
                    throw new ResubmitException();
                }
                return super.preHandle(request, response, handler);
            }
            if (this.isResubmit(request, null)) {
                throw new ResubmitException();
            }
            return super.preHandle(request, response, handler);
        }
        return super.preHandle(request, response, handler);
    }

    private boolean isResubmit(HttpServletRequest httpServletRequest, RequestMethod[] methods) throws IOException {
        boolean methodGet;
        String method = httpServletRequest.getMethod();
        boolean bl = methodGet = "GET".equals(method);
        if (methods != null && methods.length > 0) {
            for (RequestMethod m : methods) {
                if (!method.equals(m.name())) continue;
                return this.isResubmit(httpServletRequest);
            }
            return false;
        }
        if (methodGet) {
            return false;
        }
        return this.isResubmit(httpServletRequest);
    }

    private boolean isResubmit(HttpServletRequest httpServletRequest) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String params = mapper.writeValueAsString((Object)httpServletRequest.getParameterMap());
        String url = httpServletRequest.getRequestURI();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(url, params);
        String nowUrlParams = ((Object)map).toString();
        Object preUrlParams = httpServletRequest.getSession().getAttribute("repeatData");
        if (preUrlParams == null) {
            httpServletRequest.getSession().setAttribute("repeatData", (Object)nowUrlParams);
            return false;
        }
        if (preUrlParams.toString().equals(nowUrlParams)) {
            return true;
        }
        httpServletRequest.getSession().setAttribute("repeatData", (Object)nowUrlParams);
        return false;
    }
}

