

/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.arrow.vector.complex.impl;


import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.flatbuffers.FlatBufferBuilder;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.arrow.memory.*;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.Types.*;
import org.apache.arrow.vector.types.pojo.*;
import org.apache.arrow.vector.types.pojo.ArrowType.*;
import org.apache.arrow.vector.types.*;
import org.apache.arrow.vector.*;
import org.apache.arrow.vector.holders.*;
import org.apache.arrow.vector.util.*;
import org.apache.arrow.vector.complex.*;
import org.apache.arrow.vector.complex.reader.*;
import org.apache.arrow.vector.complex.impl.*;
import org.apache.arrow.vector.complex.writer.*;
import org.apache.arrow.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.arrow.vector.util.JsonStringArrayList;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.Period;







/*
 * This class is generated using freemarker and the UnionListWriter.java template.
 */

@SuppressWarnings("unused")
public class UnionListWriter extends AbstractFieldWriter {

  private ListVector vector;
  private PromotableWriter writer;
  private boolean inMap = false;
  private String mapName;
  private int lastIndex = 0;
  private static final int OFFSET_WIDTH = 4;

  public UnionListWriter(ListVector vector) {
    this(vector, NullableMapWriterFactory.getNullableMapWriterFactoryInstance());
  }

  public UnionListWriter(ListVector vector, NullableMapWriterFactory nullableMapWriterFactory) {
    this.vector = vector;
    this.writer = new PromotableWriter(vector.getDataVector(), vector, nullableMapWriterFactory);
  }

  public UnionListWriter(ListVector vector, AbstractFieldWriter parent) {
    this(vector);
  }

  @Override
  public void allocate() {
    vector.allocateNew();
  }

  @Override
  public void clear() {
    vector.clear();
  }

  @Override
  public Field getField() {
    return null;
  }

  public void setValueCount(int count) {
    vector.setValueCount(count);
  }

  @Override
  public int getValueCapacity() {
    return vector.getValueCapacity();
  }

  @Override
  public void close() throws Exception {

  }

  @Override
  public void setPosition(int index) {
    super.setPosition(index);
  }

  @Override
  public TinyIntWriter tinyInt() {
    return this;
  }

  @Override
  public TinyIntWriter tinyInt(String name) {
    mapName = name;
    return writer.tinyInt(name);
  }

  @Override
  public UInt1Writer uInt1() {
    return this;
  }

  @Override
  public UInt1Writer uInt1(String name) {
    mapName = name;
    return writer.uInt1(name);
  }

  @Override
  public UInt2Writer uInt2() {
    return this;
  }

  @Override
  public UInt2Writer uInt2(String name) {
    mapName = name;
    return writer.uInt2(name);
  }

  @Override
  public SmallIntWriter smallInt() {
    return this;
  }

  @Override
  public SmallIntWriter smallInt(String name) {
    mapName = name;
    return writer.smallInt(name);
  }

  @Override
  public IntWriter integer() {
    return this;
  }

  @Override
  public IntWriter integer(String name) {
    mapName = name;
    return writer.integer(name);
  }

  @Override
  public UInt4Writer uInt4() {
    return this;
  }

  @Override
  public UInt4Writer uInt4(String name) {
    mapName = name;
    return writer.uInt4(name);
  }

  @Override
  public Float4Writer float4() {
    return this;
  }

  @Override
  public Float4Writer float4(String name) {
    mapName = name;
    return writer.float4(name);
  }

  @Override
  public DateDayWriter dateDay() {
    return this;
  }

  @Override
  public DateDayWriter dateDay(String name) {
    mapName = name;
    return writer.dateDay(name);
  }

  @Override
  public IntervalYearWriter intervalYear() {
    return this;
  }

  @Override
  public IntervalYearWriter intervalYear(String name) {
    mapName = name;
    return writer.intervalYear(name);
  }

  @Override
  public TimeSecWriter timeSec() {
    return this;
  }

  @Override
  public TimeSecWriter timeSec(String name) {
    mapName = name;
    return writer.timeSec(name);
  }

  @Override
  public TimeMilliWriter timeMilli() {
    return this;
  }

  @Override
  public TimeMilliWriter timeMilli(String name) {
    mapName = name;
    return writer.timeMilli(name);
  }

  @Override
  public BigIntWriter bigInt() {
    return this;
  }

  @Override
  public BigIntWriter bigInt(String name) {
    mapName = name;
    return writer.bigInt(name);
  }

  @Override
  public UInt8Writer uInt8() {
    return this;
  }

  @Override
  public UInt8Writer uInt8(String name) {
    mapName = name;
    return writer.uInt8(name);
  }

  @Override
  public Float8Writer float8() {
    return this;
  }

  @Override
  public Float8Writer float8(String name) {
    mapName = name;
    return writer.float8(name);
  }

  @Override
  public DateMilliWriter dateMilli() {
    return this;
  }

  @Override
  public DateMilliWriter dateMilli(String name) {
    mapName = name;
    return writer.dateMilli(name);
  }

  @Override
  public TimeStampSecWriter timeStampSec() {
    return this;
  }

  @Override
  public TimeStampSecWriter timeStampSec(String name) {
    mapName = name;
    return writer.timeStampSec(name);
  }

  @Override
  public TimeStampMilliWriter timeStampMilli() {
    return this;
  }

  @Override
  public TimeStampMilliWriter timeStampMilli(String name) {
    mapName = name;
    return writer.timeStampMilli(name);
  }

  @Override
  public TimeStampMicroWriter timeStampMicro() {
    return this;
  }

  @Override
  public TimeStampMicroWriter timeStampMicro(String name) {
    mapName = name;
    return writer.timeStampMicro(name);
  }

  @Override
  public TimeStampNanoWriter timeStampNano() {
    return this;
  }

  @Override
  public TimeStampNanoWriter timeStampNano(String name) {
    mapName = name;
    return writer.timeStampNano(name);
  }

  @Override
  public TimeMicroWriter timeMicro() {
    return this;
  }

  @Override
  public TimeMicroWriter timeMicro(String name) {
    mapName = name;
    return writer.timeMicro(name);
  }

  @Override
  public TimeNanoWriter timeNano() {
    return this;
  }

  @Override
  public TimeNanoWriter timeNano(String name) {
    mapName = name;
    return writer.timeNano(name);
  }

  @Override
  public IntervalDayWriter intervalDay() {
    return this;
  }

  @Override
  public IntervalDayWriter intervalDay(String name) {
    mapName = name;
    return writer.intervalDay(name);
  }

  @Override
  public VarBinaryWriter varBinary() {
    return this;
  }

  @Override
  public VarBinaryWriter varBinary(String name) {
    mapName = name;
    return writer.varBinary(name);
  }

  @Override
  public VarCharWriter varChar() {
    return this;
  }

  @Override
  public VarCharWriter varChar(String name) {
    mapName = name;
    return writer.varChar(name);
  }

  @Override
  public BitWriter bit() {
    return this;
  }

  @Override
  public BitWriter bit(String name) {
    mapName = name;
    return writer.bit(name);
  }

  @Override
  public MapWriter map() {
    inMap = true;
    return this;
  }

  @Override
  public ListWriter list() {
    return writer;
  }

  @Override
  public ListWriter list(String name) {
    ListWriter listWriter = writer.list(name);
    return listWriter;
  }

  @Override
  public MapWriter map(String name) {
    MapWriter mapWriter = writer.map(name);
    return mapWriter;
  }

  @Override
  public void startList() {
    vector.startNewValue(idx());
    writer.setPosition(vector.getOffsetBuffer().getInt((idx() + 1) * OFFSET_WIDTH));
  }

  @Override
  public void endList() {
    vector.getOffsetBuffer().setInt((idx() + 1) * OFFSET_WIDTH, writer.idx());
    setPosition(idx() + 1);
  }

  @Override
  public void start() {
    writer.start();
  }

  @Override
  public void end() {
    writer.end();
    inMap = false;
  }

  @Override
  public void writeTinyInt(byte value) {
    writer.writeTinyInt(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(TinyIntHolder holder) {
    writer.writeTinyInt(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeUInt1(byte value) {
    writer.writeUInt1(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(UInt1Holder holder) {
    writer.writeUInt1(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeUInt2(char value) {
    writer.writeUInt2(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(UInt2Holder holder) {
    writer.writeUInt2(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeSmallInt(short value) {
    writer.writeSmallInt(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(SmallIntHolder holder) {
    writer.writeSmallInt(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeInt(int value) {
    writer.writeInt(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(IntHolder holder) {
    writer.writeInt(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeUInt4(int value) {
    writer.writeUInt4(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(UInt4Holder holder) {
    writer.writeUInt4(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeFloat4(float value) {
    writer.writeFloat4(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(Float4Holder holder) {
    writer.writeFloat4(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeDateDay(int value) {
    writer.writeDateDay(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(DateDayHolder holder) {
    writer.writeDateDay(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeIntervalYear(int value) {
    writer.writeIntervalYear(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(IntervalYearHolder holder) {
    writer.writeIntervalYear(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeTimeSec(int value) {
    writer.writeTimeSec(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(TimeSecHolder holder) {
    writer.writeTimeSec(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeTimeMilli(int value) {
    writer.writeTimeMilli(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(TimeMilliHolder holder) {
    writer.writeTimeMilli(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeBigInt(long value) {
    writer.writeBigInt(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(BigIntHolder holder) {
    writer.writeBigInt(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeUInt8(long value) {
    writer.writeUInt8(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(UInt8Holder holder) {
    writer.writeUInt8(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeFloat8(double value) {
    writer.writeFloat8(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(Float8Holder holder) {
    writer.writeFloat8(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeDateMilli(long value) {
    writer.writeDateMilli(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(DateMilliHolder holder) {
    writer.writeDateMilli(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeTimeStampSec(long value) {
    writer.writeTimeStampSec(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(TimeStampSecHolder holder) {
    writer.writeTimeStampSec(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeTimeStampMilli(long value) {
    writer.writeTimeStampMilli(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(TimeStampMilliHolder holder) {
    writer.writeTimeStampMilli(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeTimeStampMicro(long value) {
    writer.writeTimeStampMicro(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(TimeStampMicroHolder holder) {
    writer.writeTimeStampMicro(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeTimeStampNano(long value) {
    writer.writeTimeStampNano(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(TimeStampNanoHolder holder) {
    writer.writeTimeStampNano(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeTimeMicro(long value) {
    writer.writeTimeMicro(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(TimeMicroHolder holder) {
    writer.writeTimeMicro(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeTimeNano(long value) {
    writer.writeTimeNano(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(TimeNanoHolder holder) {
    writer.writeTimeNano(holder.value);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeIntervalDay(int days, int milliseconds) {
    writer.writeIntervalDay(days, milliseconds);
    writer.setPosition(writer.idx()+1);
  }

  public void write(IntervalDayHolder holder) {
    writer.writeIntervalDay(holder.days, holder.milliseconds);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeVarBinary(int start, int end, ArrowBuf buffer) {
    writer.writeVarBinary(start, end, buffer);
    writer.setPosition(writer.idx()+1);
  }

  public void write(VarBinaryHolder holder) {
    writer.writeVarBinary(holder.start, holder.end, holder.buffer);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeVarChar(int start, int end, ArrowBuf buffer) {
    writer.writeVarChar(start, end, buffer);
    writer.setPosition(writer.idx()+1);
  }

  public void write(VarCharHolder holder) {
    writer.writeVarChar(holder.start, holder.end, holder.buffer);
    writer.setPosition(writer.idx()+1);
  }

  @Override
  public void writeBit(int value) {
    writer.writeBit(value);
    writer.setPosition(writer.idx()+1);
  }

  public void write(BitHolder holder) {
    writer.writeBit(holder.value);
    writer.setPosition(writer.idx()+1);
  }

}
