/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.unix;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.DomainSocketWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestDomainSocketWatcher {
    static final Log LOG = LogFactory.getLog(TestDomainSocketWatcher.class);
    private Throwable trappedException = null;

    @Before
    public void before() {
        Assume.assumeTrue((DomainSocket.getLoadingFailureReason() == null ? 1 : 0) != 0);
    }

    @After
    public void after() {
        if (this.trappedException != null) {
            throw new IllegalStateException("DomainSocketWatcher thread terminated with unexpected exception.", this.trappedException);
        }
    }

    @Test(timeout=60000L)
    public void testCreateShutdown() throws Exception {
        DomainSocketWatcher watcher = this.newDomainSocketWatcher(10000000);
        watcher.close();
    }

    @Test(timeout=180000L)
    public void testDeliverNotifications() throws Exception {
        DomainSocketWatcher watcher = this.newDomainSocketWatcher(10000000);
        DomainSocket[] pair = DomainSocket.socketpair();
        final CountDownLatch latch = new CountDownLatch(1);
        watcher.add(pair[1], new DomainSocketWatcher.Handler(){

            public boolean handle(DomainSocket sock) {
                latch.countDown();
                return true;
            }
        });
        pair[0].close();
        latch.await();
        watcher.close();
    }

    @Test(timeout=60000L)
    public void testInterruption() throws Exception {
        DomainSocketWatcher watcher = this.newDomainSocketWatcher(10);
        watcher.watcherThread.interrupt();
        Uninterruptibles.joinUninterruptibly((Thread)watcher.watcherThread);
        watcher.close();
    }

    @Test(timeout=300000L)
    public void testCloseSocketOnWatcherClose() throws Exception {
        DomainSocketWatcher watcher = this.newDomainSocketWatcher(10000000);
        DomainSocket[] pair = DomainSocket.socketpair();
        watcher.add(pair[1], new DomainSocketWatcher.Handler(){

            public boolean handle(DomainSocket sock) {
                return true;
            }
        });
        watcher.close();
        Uninterruptibles.joinUninterruptibly((Thread)watcher.watcherThread);
        Assert.assertFalse((boolean)pair[1].isOpen());
    }

    @Test(timeout=300000L)
    public void testStress() throws Exception {
        int SOCKET_NUM = 250;
        final ReentrantLock lock = new ReentrantLock();
        final DomainSocketWatcher watcher = this.newDomainSocketWatcher(10000000);
        final ArrayList pairs = new ArrayList();
        final AtomicInteger handled = new AtomicInteger(0);
        Thread adderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 250; ++i) {
                        DomainSocket[] pair = DomainSocket.socketpair();
                        watcher.add(pair[1], new DomainSocketWatcher.Handler(){

                            public boolean handle(DomainSocket sock) {
                                handled.incrementAndGet();
                                return true;
                            }
                        });
                        lock.lock();
                        try {
                            pairs.add(pair);
                            continue;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error((Object)e);
                    throw new RuntimeException(e);
                }
            }
        });
        Thread removerThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Random random = new Random();
                try {
                    while (handled.get() != 250) {
                        lock.lock();
                        try {
                            if (pairs.isEmpty()) continue;
                            int idx = random.nextInt(pairs.size());
                            DomainSocket[] pair = (DomainSocket[])pairs.remove(idx);
                            if (random.nextBoolean()) {
                                pair[0].close();
                                continue;
                            }
                            watcher.remove(pair[1]);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
                catch (Throwable e) {
                    LOG.error((Object)e);
                    throw new RuntimeException(e);
                }
            }
        });
        adderThread.start();
        removerThread.start();
        Uninterruptibles.joinUninterruptibly((Thread)adderThread);
        Uninterruptibles.joinUninterruptibly((Thread)removerThread);
        watcher.close();
    }

    private DomainSocketWatcher newDomainSocketWatcher(int interruptCheckPeriodMs) throws Exception {
        DomainSocketWatcher watcher = new DomainSocketWatcher(interruptCheckPeriodMs, this.getClass().getSimpleName());
        watcher.watcherThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable t) {
                TestDomainSocketWatcher.this.trappedException = t;
            }
        });
        return watcher;
    }
}

