/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import org.apache.kafka.common.KafkaException;

public final class ApiUtils$ {
    public static ApiUtils$ MODULE$;
    private final String ProtocolEncoding;

    static {
        new ApiUtils$();
    }

    public String ProtocolEncoding() {
        return this.ProtocolEncoding;
    }

    public String readShortString(ByteBuffer buffer) {
        short size = buffer.getShort();
        if (size < 0) {
            return null;
        }
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return new String(bytes, this.ProtocolEncoding());
    }

    public void writeShortString(ByteBuffer buffer, String string) {
        if (string == null) {
            buffer.putShort((short)-1);
        } else {
            byte[] encodedString = string.getBytes(this.ProtocolEncoding());
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder(36).append("String exceeds the maximum size of ").append(Short.MAX_VALUE).append(".").toString());
            }
            buffer.putShort((short)encodedString.length);
            buffer.put(encodedString);
        }
    }

    public int shortStringLength(String string) {
        int n;
        if (string == null) {
            n = 2;
        } else {
            byte[] encodedString = string.getBytes(this.ProtocolEncoding());
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder(36).append("String exceeds the maximum size of ").append(Short.MAX_VALUE).append(".").toString());
            }
            n = 2 + encodedString.length;
        }
        return n;
    }

    private ApiUtils$() {
        MODULE$ = this;
        this.ProtocolEncoding = "UTF-8";
    }
}

