/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionCacheEntry;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;

public class SetDecisionTableCategoryCmd
implements Command<Void> {
    protected String decisionTableId;
    protected String category;

    public SetDecisionTableCategoryCmd(String decisionTableId, String category) {
        this.decisionTableId = decisionTableId;
        this.category = category;
    }

    public Void execute(CommandContext commandContext) {
        if (this.decisionTableId == null) {
            throw new FlowableIllegalArgumentException("Decision table id is null");
        }
        DecisionEntity decisionTable = (DecisionEntity)CommandContextUtil.getDecisionEntityManager(commandContext).findById(this.decisionTableId);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("No decision table found for id = '" + this.decisionTableId + "'");
        }
        decisionTable.setCategory(this.category);
        DeploymentCache<DecisionCacheEntry> decisionTableCache = CommandContextUtil.getDmnEngineConfiguration().getDefinitionCache();
        if (decisionTableCache != null) {
            decisionTableCache.remove(this.decisionTableId);
        }
        CommandContextUtil.getDecisionEntityManager(commandContext).update(decisionTable);
        return null;
    }

    public String getDecisionTableId() {
        return this.decisionTableId;
    }

    public void setDecisionTableId(String decisionTableId) {
        this.decisionTableId = decisionTableId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

