/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.exception;

import java.util.Date;
import org.hibernate.envers.exception.AuditException;

public class RevisionDoesNotExistException
extends AuditException {
    private static final long serialVersionUID = -6417768274074962282L;
    private final Number revision;
    private final Date date;

    public RevisionDoesNotExistException(Number revision) {
        super("Revision " + revision + " does not exist.");
        this.revision = revision;
        this.date = null;
    }

    public RevisionDoesNotExistException(Date date) {
        super("There is no revision before or at " + date + ".");
        this.date = date;
        this.revision = null;
    }

    public Number getRevision() {
        return this.revision;
    }

    public Date getDate() {
        return this.date;
    }
}

