/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.server.rest.repr.IndexDefinitionRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.RepresentationTestAccess;

public class SchemaIndexRepresentationTest {
    @Test
    public void shouldIncludeLabel() {
        String labelName = "person";
        String propertyKey = "name";
        IndexDefinition definition = (IndexDefinition)Mockito.mock(IndexDefinition.class);
        Mockito.when((Object)definition.getLabel()).thenReturn((Object)Label.label((String)labelName));
        Mockito.when((Object)definition.getPropertyKeys()).thenReturn(Arrays.asList(propertyKey));
        IndexDefinitionRepresentation representation = new IndexDefinitionRepresentation(definition);
        Map<String, Object> serialized = RepresentationTestAccess.serialize((MappingRepresentation)representation);
        Assert.assertEquals(Arrays.asList(propertyKey), (Object)serialized.get("property_keys"));
        Assert.assertEquals((Object)labelName, (Object)serialized.get("label"));
    }
}

