/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.util.OptionalHostnamePort;

class AddressResolver {
    AddressResolver() {
    }

    HostnamePort resolveCorrectHAAddress(Config config, OptionalHostnamePort userProvidedAddress) {
        HostnamePort defaultValues = this.readDefaultConfigAddressHA(config);
        return new HostnamePort(userProvidedAddress.getHostname().orElse(defaultValues.getHost()), userProvidedAddress.getPort().orElse(defaultValues.getPort()).intValue());
    }

    AdvertisedSocketAddress resolveCorrectCCAddress(Config config, OptionalHostnamePort userProvidedAddress) {
        AdvertisedSocketAddress defaultValue = this.readDefaultConfigAddressCC(config);
        return new AdvertisedSocketAddress(userProvidedAddress.getHostname().orElse(defaultValue.getHostname()), userProvidedAddress.getPort().orElse(defaultValue.getPort()).intValue());
    }

    private HostnamePort readDefaultConfigAddressHA(Config config) {
        return (HostnamePort)config.get(OnlineBackupSettings.online_backup_server);
    }

    private AdvertisedSocketAddress readDefaultConfigAddressCC(Config config) {
        return this.advertisedFromListenAddress((ListenSocketAddress)config.get(CausalClusteringSettings.transaction_listen_address));
    }

    private AdvertisedSocketAddress advertisedFromListenAddress(ListenSocketAddress listenSocketAddress) {
        return new AdvertisedSocketAddress(listenSocketAddress.getHostname(), listenSocketAddress.getPort());
    }
}

