/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.impl;

import java.nio.file.Path;
import org.neo4j.backup.impl.BackupStrategyCoordinator;
import org.neo4j.backup.impl.BackupStrategyCoordinatorFactory;
import org.neo4j.backup.impl.BackupSupportingClasses;
import org.neo4j.backup.impl.BackupSupportingClassesFactory;
import org.neo4j.backup.impl.OnlineBackupContext;
import org.neo4j.backup.impl.OnlineBackupContextBuilder;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;

class OnlineBackupCommand
implements AdminCommand {
    private final OutsideWorld outsideWorld;
    private final OnlineBackupContextBuilder contextBuilder;
    private final BackupStrategyCoordinatorFactory backupStrategyCoordinatorFactory;
    private final BackupSupportingClassesFactory backupSupportingClassesFactory;

    OnlineBackupCommand(OutsideWorld outsideWorld, OnlineBackupContextBuilder contextBuilder, BackupSupportingClassesFactory backupSupportingClassesFactory, BackupStrategyCoordinatorFactory backupStrategyCoordinatorFactory) {
        this.outsideWorld = outsideWorld;
        this.contextBuilder = contextBuilder;
        this.backupSupportingClassesFactory = backupSupportingClassesFactory;
        this.backupStrategyCoordinatorFactory = backupStrategyCoordinatorFactory;
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        OnlineBackupContext onlineBackupContext = this.contextBuilder.createContext(args);
        BackupSupportingClasses backupSupportingClasses = this.backupSupportingClassesFactory.createSupportingClasses(onlineBackupContext.getConfig());
        this.checkDestination(onlineBackupContext.getRequiredArguments().getDirectory());
        this.checkDestination(onlineBackupContext.getRequiredArguments().getReportDir());
        BackupStrategyCoordinator backupStrategyCoordinator = this.backupStrategyCoordinatorFactory.backupStrategyCoordinator(onlineBackupContext, backupSupportingClasses.getBackupProtocolService(), backupSupportingClasses.getBackupDelegator(), backupSupportingClasses.getPageCache());
        backupStrategyCoordinator.performBackup(onlineBackupContext);
        this.outsideWorld.stdOutLine("Backup complete.");
    }

    private void checkDestination(Path path) throws CommandFailed {
        if (!this.outsideWorld.fileSystem().isDirectory(path.toFile())) {
            throw new CommandFailed(String.format("Directory '%s' does not exist.", path));
        }
    }
}

