/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.causalclustering.catchup.storecopy.CloseablesListener;

public class CloseablesListenerTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldCloseAllReourcesBeforeException() throws Exception {
        CloseablesListener closeablesListener = new CloseablesListener();
        RuntimeException exception = new RuntimeException("fail");
        CloseTrackingCloseable kindCloseable1 = new CloseTrackingCloseable();
        CloseTrackingCloseable unkindCloseable = new CloseTrackingCloseable(exception);
        CloseTrackingCloseable kindCloseable2 = new CloseTrackingCloseable();
        closeablesListener.add((AutoCloseable)kindCloseable1);
        closeablesListener.add((AutoCloseable)unkindCloseable);
        closeablesListener.add((AutoCloseable)kindCloseable2);
        this.expectedException.expect(exception.getClass());
        closeablesListener.close();
        Assert.assertTrue((boolean)kindCloseable1.wasClosed);
        Assert.assertTrue((boolean)unkindCloseable.wasClosed);
        Assert.assertTrue((boolean)kindCloseable2.wasClosed);
    }

    class CloseTrackingCloseable
    implements AutoCloseable {
        private final Exception throwOnClose;
        boolean wasClosed;

        private CloseTrackingCloseable() {
            this((Exception)null);
        }

        CloseTrackingCloseable(Exception throwOnClose) {
            this.throwOnClose = throwOnClose;
        }

        @Override
        public void close() throws Exception {
            this.wasClosed = true;
            if (this.throwOnClose != null) {
                throw this.throwOnClose;
            }
        }
    }
}

