/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.causalclustering.catchup.storecopy.MaximumTotalTime;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.time.FakeClock;

public class MaximumTotalTimeTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldFailWhenAllowedTimeHasPassed() throws StoreCopyFailedException {
        TimeUnit timeUnit = TimeUnit.SECONDS;
        FakeClock fakeClock = new FakeClock(0L, timeUnit);
        MaximumTotalTime maximumTotalTime = new MaximumTotalTime(5L, timeUnit, (Clock)fakeClock);
        maximumTotalTime.assertContinue();
        fakeClock.forward(5L, timeUnit);
        maximumTotalTime.assertContinue();
        this.expectedException.expect(StoreCopyFailedException.class);
        fakeClock.forward(1L, timeUnit);
        maximumTotalTime.assertContinue();
    }
}

