/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.explorer;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.explorer.ComparableRaftState;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;

public class ClusterState {
    public final Map<MemberId, Role> roles;
    public final Map<MemberId, ComparableRaftState> states;
    public final Map<MemberId, Queue<RaftMessages.RaftMessage>> queues;

    public ClusterState(Set<MemberId> members) throws IOException {
        this.roles = new HashMap<MemberId, Role>();
        this.states = new HashMap<MemberId, ComparableRaftState>();
        this.queues = new HashMap<MemberId, Queue<RaftMessages.RaftMessage>>();
        for (MemberId member : members) {
            this.roles.put(member, Role.FOLLOWER);
            RaftState memberState = RaftStateBuilder.raftState().myself(member).votingMembers(members).build();
            this.states.put(member, new ComparableRaftState((ReadableRaftState)memberState));
            this.queues.put(member, new LinkedList());
        }
    }

    public ClusterState(ClusterState original) {
        this.roles = new HashMap<MemberId, Role>(original.roles);
        this.states = new HashMap<MemberId, ComparableRaftState>(original.states);
        this.queues = new HashMap<MemberId, Queue<RaftMessages.RaftMessage>>(original.queues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterState that = (ClusterState)o;
        return Objects.equals(this.roles, that.roles) && Objects.equals(this.states, that.states) && Objects.equals(this.queues, that.queues);
    }

    public int hashCode() {
        return Objects.hash(this.roles, this.states, this.queues);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (MemberId member : this.roles.keySet()) {
            builder.append(member).append(" : ").append(this.roles.get(member)).append("\n");
            builder.append("  state: ").append(this.states.get(member)).append("\n");
            builder.append("  queue: ").append(this.queues.get(member)).append("\n");
        }
        return builder.toString();
    }
}

