/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.log.segmented.EntryBasedLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.PruningStrategyTest;
import org.neo4j.logging.LogProvider;

public class EntryBasedLogPruningStrategyTest
extends PruningStrategyTest {
    @Test
    public void indexToKeepTest() {
        this.files = this.createSegmentFiles(10);
        EntryBasedLogPruningStrategy strategy = new EntryBasedLogPruningStrategy(6L, (LogProvider)Mockito.mock(LogProvider.class));
        long indexToKeep = strategy.getIndexToKeep(this.segments);
        Assert.assertEquals((long)2L, (long)indexToKeep);
    }

    @Test
    public void pruneStrategyExceedsNumberOfEntriesTest() {
        this.files = this.createSegmentFiles(10).subList(5, 10);
        EntryBasedLogPruningStrategy strategy = new EntryBasedLogPruningStrategy(7L, (LogProvider)Mockito.mock(LogProvider.class));
        long indexToKeep = strategy.getIndexToKeep(this.segments);
        Assert.assertEquals((long)4L, (long)indexToKeep);
    }

    @Test
    public void onlyFirstActiveLogFileTest() {
        this.files = this.createSegmentFiles(1);
        EntryBasedLogPruningStrategy strategy = new EntryBasedLogPruningStrategy(6L, (LogProvider)Mockito.mock(LogProvider.class));
        long indexToKeep = strategy.getIndexToKeep(this.segments);
        Assert.assertEquals((long)-1L, (long)indexToKeep);
    }

    @Test
    public void onlyOneActiveLogFileTest() {
        this.files = this.createSegmentFiles(6).subList(4, 6);
        EntryBasedLogPruningStrategy strategy = new EntryBasedLogPruningStrategy(6L, (LogProvider)Mockito.mock(LogProvider.class));
        long indexToKeep = strategy.getIndexToKeep(this.segments);
        Assert.assertEquals((long)3L, (long)indexToKeep);
    }
}

