/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.time.Clock;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.core.consensus.log.DummyRaftableContentSerializer;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogContractTest;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.time.Clocks;

public class SegmentedRaftLogContractTest
extends RaftLogContractTest {
    private final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final LifeRule life = new LifeRule(true);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.fsRule).around((TestRule)this.life);

    @Override
    public RaftLog createRaftLog() {
        File directory = new File("raft-log");
        FileSystemAbstraction fileSystem = this.fsRule.get();
        fileSystem.mkdir(directory);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory("1 entries", (LogProvider)logProvider).newInstance();
        return (RaftLog)this.life.add((Lifecycle)new SegmentedRaftLog(fileSystem, directory, 1024L, (ChannelMarshal)new DummyRaftableContentSerializer(), (LogProvider)logProvider, 8, (Clock)Clocks.fakeClock(), (JobScheduler)new OnDemandJobScheduler(), pruningStrategy));
    }
}

