/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.log.DummyRaftableContentSerializer;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogVerificationIT;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.time.Clocks;

public class SegmentedRaftLogVerificationIT
extends RaftLogVerificationIT {
    @Override
    protected RaftLog createRaftLog() throws Throwable {
        FileSystemAbstraction fsa = this.fsRule.get();
        File directory = new File("raft-log");
        fsa.mkdir(directory);
        long rotateAtSizeBytes = 128L;
        int readerPoolSize = 8;
        NullLogProvider logProvider = NullLogProvider.getInstance();
        CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory(CausalClusteringSettings.raft_log_pruning_strategy.getDefaultValue(), (LogProvider)logProvider).newInstance();
        SegmentedRaftLog newRaftLog = new SegmentedRaftLog(fsa, directory, rotateAtSizeBytes, (ChannelMarshal)new DummyRaftableContentSerializer(), (LogProvider)logProvider, readerPoolSize, Clocks.systemClock(), (JobScheduler)new OnDemandJobScheduler(), pruningStrategy);
        newRaftLog.init();
        newRaftLog.start();
        return newRaftLog;
    }

    @Override
    protected long operations() {
        return 500L;
    }
}

