/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.log.InMemoryVersionableReadableClosablePositionAwareChannel;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class IdAllocationStateTest {
    @Test
    public void shouldRoundtripToChannel() throws Exception {
        IdAllocationState state = new IdAllocationState();
        for (int i = 1; i <= 3; ++i) {
            state.firstUnallocated(IdType.NODE, (long)(1024 * i));
            state.logIndex((long)i);
        }
        IdAllocationState.Marshal marshal = new IdAllocationState.Marshal();
        InMemoryVersionableReadableClosablePositionAwareChannel channel = new InMemoryVersionableReadableClosablePositionAwareChannel();
        marshal.marshal(state, (WritableChannel)channel);
        IdAllocationState unmarshalled = (IdAllocationState)marshal.unmarshal((ReadableChannel)channel);
        Assert.assertEquals((Object)state, (Object)unmarshalled);
    }

    @Test
    public void shouldThrowExceptionForHalfWrittenEntries() throws IOException, EndOfStreamException {
        IdAllocationState state = new IdAllocationState();
        for (int i = 1; i <= 3; ++i) {
            state.firstUnallocated(IdType.NODE, (long)(1024 * i));
            state.logIndex((long)i);
        }
        IdAllocationState.Marshal marshal = new IdAllocationState.Marshal();
        InMemoryVersionableReadableClosablePositionAwareChannel channel = new InMemoryVersionableReadableClosablePositionAwareChannel();
        marshal.marshal(state, (WritableChannel)channel);
        channel.putInt(1).putInt(2).putInt(3).putLong(4L);
        marshal.unmarshal((ReadableChannel)channel);
        try {
            marshal.unmarshal((ReadableChannel)channel);
            Assert.fail();
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
    }
}

