/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.state.ExposedRaftState;
import org.neo4j.causalclustering.core.state.machines.id.CommandIndexTracker;
import org.neo4j.causalclustering.core.state.machines.id.FreeIdFilteredIdGenerator;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocation;
import org.neo4j.causalclustering.core.state.machines.id.IdReusabilityCondition;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdGenerator;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.IdGeneratorContractTest;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class ReplicatedIdGeneratorTest
extends IdGeneratorContractTest {
    private NullLogProvider logProvider = NullLogProvider.getInstance();
    @Rule
    public FileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private File file;
    private FileSystemAbstraction fs;
    private MemberId myself = new MemberId(UUID.randomUUID());
    private RaftMachine raftMachine = (RaftMachine)Mockito.mock(RaftMachine.class);
    private ExposedRaftState state = (ExposedRaftState)Mockito.mock(ExposedRaftState.class);
    private final CommandIndexTracker commandIndexTracker = (CommandIndexTracker)Mockito.mock(CommandIndexTracker.class);
    private IdReusabilityCondition idReusabilityCondition;
    private ReplicatedIdGenerator idGenerator;

    @Before
    public void setUp() {
        this.file = this.testDirectory.file("idgen");
        this.fs = this.fileSystemRule.get();
        Mockito.when((Object)this.raftMachine.state()).thenReturn((Object)this.state);
        this.idReusabilityCondition = this.getIdReusabilityCondition();
    }

    @After
    public void tearDown() {
        if (this.idGenerator != null) {
            this.idGenerator.close();
        }
    }

    protected IdGenerator createIdGenerator(int grabSize) {
        return this.openIdGenerator(grabSize);
    }

    protected IdGenerator openIdGenerator(int grabSize) {
        ReplicatedIdGenerator replicatedIdGenerator = new ReplicatedIdGenerator(this.fs, this.file, IdType.NODE, () -> 0L, this.stubAcquirer(), (LogProvider)this.logProvider, grabSize, true);
        return new FreeIdFilteredIdGenerator((IdGenerator)replicatedIdGenerator, (BooleanSupplier)this.idReusabilityCondition);
    }

    @Test
    public void shouldCreateIdFileForPersistence() {
        ReplicatedIdRangeAcquirer rangeAcquirer = this.simpleRangeAcquirer(IdType.NODE, 0L, 1024);
        this.idGenerator = new ReplicatedIdGenerator(this.fs, this.file, IdType.NODE, () -> 0L, rangeAcquirer, (LogProvider)this.logProvider, 10, true);
        Assert.assertTrue((boolean)this.fs.fileExists(this.file));
    }

    @Test
    public void shouldNotStepBeyondAllocationBoundaryWithoutBurnedId() {
        ReplicatedIdRangeAcquirer rangeAcquirer = this.simpleRangeAcquirer(IdType.NODE, 0L, 1024);
        this.idGenerator = new ReplicatedIdGenerator(this.fs, this.file, IdType.NODE, () -> 0L, rangeAcquirer, (LogProvider)this.logProvider, 10, true);
        Set<Long> idsGenerated = this.collectGeneratedIds(this.idGenerator, 1024L);
        long minId = Collections.min(idsGenerated);
        long maxId = Collections.max(idsGenerated);
        Assert.assertEquals((long)0L, (long)minId);
        Assert.assertEquals((long)1023L, (long)maxId);
    }

    @Test
    public void shouldNotStepBeyondAllocationBoundaryWithBurnedId() {
        ReplicatedIdRangeAcquirer rangeAcquirer = this.simpleRangeAcquirer(IdType.NODE, 0L, 1024);
        long burnedIds = 23L;
        this.idGenerator = new ReplicatedIdGenerator(this.fs, this.file, IdType.NODE, () -> burnedIds, rangeAcquirer, (LogProvider)this.logProvider, 10, true);
        Set<Long> idsGenerated = this.collectGeneratedIds(this.idGenerator, 1024L - burnedIds);
        long minId = Collections.min(idsGenerated);
        long maxId = Collections.max(idsGenerated);
        Assert.assertEquals((long)burnedIds, (long)minId);
        Assert.assertEquals((long)1023L, (long)maxId);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIfAdjustmentFailsDueToInconsistentValues() {
        ReplicatedIdRangeAcquirer rangeAcquirer = (ReplicatedIdRangeAcquirer)Mockito.mock(ReplicatedIdRangeAcquirer.class);
        Mockito.when((Object)rangeAcquirer.acquireIds(IdType.NODE)).thenReturn((Object)this.allocation(3L, 21, 21));
        this.idGenerator = new ReplicatedIdGenerator(this.fs, this.file, IdType.NODE, () -> 42L, rangeAcquirer, (LogProvider)this.logProvider, 10, true);
        this.idGenerator.nextId();
    }

    @Test
    public void shouldReuseIdOnlyWhenLeader() {
        ReplicatedIdRangeAcquirer rangeAcquirer = this.simpleRangeAcquirer(IdType.NODE, 0L, 1024);
        long burnedIds = 23L;
        try (FreeIdFilteredIdGenerator idGenerator = new FreeIdFilteredIdGenerator((IdGenerator)new ReplicatedIdGenerator(this.fs, this.file, IdType.NODE, () -> burnedIds, rangeAcquirer, (LogProvider)this.logProvider, 10, true), (BooleanSupplier)this.idReusabilityCondition);){
            idGenerator.freeId(10L);
            Assert.assertEquals((long)0L, (long)idGenerator.getDefragCount());
            Assert.assertEquals((long)23L, (long)idGenerator.nextId());
            Mockito.when((Object)this.commandIndexTracker.getAppliedCommandIndex()).thenReturn((Object)6L);
            Mockito.when((Object)this.state.lastLogIndexBeforeWeBecameLeader()).thenReturn((Object)5L);
            this.idReusabilityCondition.onLeaderSwitch(new LeaderInfo(this.myself, 1L));
            idGenerator.freeId(10L);
            Assert.assertEquals((long)1L, (long)idGenerator.getDefragCount());
            Assert.assertEquals((long)10L, (long)idGenerator.nextId());
            Assert.assertEquals((long)0L, (long)idGenerator.getDefragCount());
        }
    }

    @Test
    public void shouldReuseIdBeforeHighId() {
        ReplicatedIdRangeAcquirer rangeAcquirer = this.simpleRangeAcquirer(IdType.NODE, 0L, 1024);
        long burnedIds = 23L;
        this.idGenerator = new ReplicatedIdGenerator(this.fs, this.file, IdType.NODE, () -> burnedIds, rangeAcquirer, (LogProvider)this.logProvider, 10, true);
        Assert.assertEquals((long)23L, (long)this.idGenerator.nextId());
        this.idGenerator.freeId(10L);
        this.idGenerator.freeId(5L);
        Assert.assertEquals((long)10L, (long)this.idGenerator.nextId());
        Assert.assertEquals((long)5L, (long)this.idGenerator.nextId());
        Assert.assertEquals((long)24L, (long)this.idGenerator.nextId());
    }

    @Test
    public void freeIdOnlyWhenReusabilityConditionAllows() {
        ReplicatedIdRangeAcquirer rangeAcquirer = this.simpleRangeAcquirer(IdType.NODE, 0L, 1024);
        IdReusabilityCondition idReusabilityCondition = this.getIdReusabilityCondition();
        long burnedIds = 23L;
        try (FreeIdFilteredIdGenerator idGenerator = new FreeIdFilteredIdGenerator((IdGenerator)new ReplicatedIdGenerator(this.fs, this.file, IdType.NODE, () -> burnedIds, rangeAcquirer, (LogProvider)this.logProvider, 10, true), (BooleanSupplier)idReusabilityCondition);){
            idGenerator.freeId(10L);
            Assert.assertEquals((long)0L, (long)idGenerator.getDefragCount());
            Assert.assertEquals((long)23L, (long)idGenerator.nextId());
            Mockito.when((Object)this.commandIndexTracker.getAppliedCommandIndex()).thenReturn((Object)4L, (Object[])new Long[]{6L});
            Mockito.when((Object)this.state.lastLogIndexBeforeWeBecameLeader()).thenReturn((Object)5L);
            idReusabilityCondition.onLeaderSwitch(new LeaderInfo(this.myself, 1L));
            Assert.assertEquals((long)24L, (long)idGenerator.nextId());
            idGenerator.freeId(11L);
            Assert.assertEquals((long)25L, (long)idGenerator.nextId());
            idGenerator.freeId(6L);
            Assert.assertEquals((long)6L, (long)idGenerator.nextId());
        }
    }

    private IdReusabilityCondition getIdReusabilityCondition() {
        return new IdReusabilityCondition(this.commandIndexTracker, this.raftMachine, this.myself);
    }

    private Set<Long> collectGeneratedIds(ReplicatedIdGenerator idGenerator, long expectedIds) {
        HashSet<Long> idsGenerated = new HashSet<Long>();
        int i = 0;
        while ((long)i < expectedIds) {
            long nextId = idGenerator.nextId();
            Assert.assertThat((Object)nextId, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
            idsGenerated.add(nextId);
            ++i;
        }
        try {
            idGenerator.nextId();
            Assert.fail((String)("Too many ids produced, expected " + expectedIds));
        }
        catch (NoMoreIds noMoreIds) {
            // empty catch block
        }
        return idsGenerated;
    }

    private ReplicatedIdRangeAcquirer simpleRangeAcquirer(IdType idType, long start, int length) {
        ReplicatedIdRangeAcquirer rangeAcquirer = (ReplicatedIdRangeAcquirer)Mockito.mock(ReplicatedIdRangeAcquirer.class);
        Mockito.when((Object)rangeAcquirer.acquireIds(idType)).thenReturn((Object)this.allocation(start, length, -1)).thenThrow(NoMoreIds.class);
        return rangeAcquirer;
    }

    private IdAllocation allocation(long start, int length, int highestIdInUse) {
        return new IdAllocation(new IdRange(new long[0], start, length), (long)highestIdInUse, 0L);
    }

    private ReplicatedIdRangeAcquirer stubAcquirer() {
        ReplicatedIdRangeAcquirer rangeAcquirer = (ReplicatedIdRangeAcquirer)Mockito.mock(ReplicatedIdRangeAcquirer.class);
        Mockito.when((Object)rangeAcquirer.acquireIds(IdType.NODE)).thenReturn((Object)this.allocation(0L, 1024, -1)).thenReturn((Object)this.allocation(1024L, 1024, 1023)).thenReturn((Object)this.allocation(2048L, 1024, 2047)).thenReturn((Object)this.allocation(3072L, 1024, 3071)).thenReturn((Object)this.allocation(4096L, 1024, 4095)).thenReturn((Object)this.allocation(5120L, 1024, 5119)).thenReturn((Object)this.allocation(6144L, 1024, 6143)).thenReturn((Object)this.allocation(7168L, 1024, 7167)).thenReturn((Object)this.allocation(8192L, 1024, 8191)).thenReturn((Object)this.allocation(9216L, 1024, 9215)).thenReturn((Object)this.allocation(-1L, 0, 10240));
        return rangeAcquirer;
    }

    private static class NoMoreIds
    extends RuntimeException {
        private NoMoreIds() {
        }
    }
}

