/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.naming.NamingException;
import org.neo4j.causalclustering.discovery.SrvRecordResolver;

public class MockSrvRecordResolver
extends SrvRecordResolver {
    private final HashMap<String, List<SrvRecordResolver.SrvRecord>> records;

    public MockSrvRecordResolver(HashMap<String, List<SrvRecordResolver.SrvRecord>> records) {
        this.records = records;
    }

    public void addRecords(String url, Collection<SrvRecordResolver.SrvRecord> records) {
        records.forEach(r -> this.addRecord(url, (SrvRecordResolver.SrvRecord)r));
    }

    public synchronized void addRecord(String url, SrvRecordResolver.SrvRecord record) {
        List srvRecords = this.records.getOrDefault(url, new ArrayList());
        srvRecords.add(record);
        if (!this.records.containsKey(url)) {
            this.records.put(url, srvRecords);
        }
    }

    public Stream<SrvRecordResolver.SrvRecord> resolveSrvRecord(String url) throws NamingException {
        List<SrvRecordResolver.SrvRecord> srvRecords = this.records.get(url);
        if (srvRecords == null) {
            NamingException e = new NamingException("No SRV records found");
            e.appendRemainingComponent(url);
            throw e;
        }
        return srvRecords.stream();
    }
}

