/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyListenerService;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class SharedDiscoveryCoreClient
implements CoreTopologyService,
Lifecycle {
    private final SharedDiscoveryService sharedDiscoveryService;
    private final MemberId myself;
    private final CoreServerInfo coreServerInfo;
    private final CoreTopologyListenerService listenerService;
    private final Log log;
    private final boolean refusesToBeLeader;
    private final String localDBName;
    private volatile LeaderInfo leaderInfo = LeaderInfo.INITIAL;
    private volatile CoreTopology coreTopology;
    private volatile ReadReplicaTopology readReplicaTopology;

    SharedDiscoveryCoreClient(SharedDiscoveryService sharedDiscoveryService, MemberId member, LogProvider logProvider, Config config) {
        this.sharedDiscoveryService = sharedDiscoveryService;
        this.listenerService = new CoreTopologyListenerService();
        this.myself = member;
        this.coreServerInfo = SharedDiscoveryCoreClient.extractCoreServerInfo(config);
        this.log = logProvider.getLog(this.getClass());
        this.refusesToBeLeader = (Boolean)config.get(CausalClusteringSettings.refuse_to_be_leader);
        this.localDBName = (String)config.get(CausalClusteringSettings.database);
    }

    public synchronized void addLocalCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listenerService.addCoreTopologyListener(listener);
        listener.onCoreTopologyChange(this.localCoreServers());
    }

    public void removeLocalCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listenerService.removeCoreTopologyListener(listener);
    }

    public boolean setClusterId(ClusterId clusterId, String dbName) {
        return this.sharedDiscoveryService.casClusterId(clusterId, dbName);
    }

    public Map<MemberId, RoleInfo> allCoreRoles() {
        return this.sharedDiscoveryService.getCoreRoles();
    }

    public void setLeader(LeaderInfo newLeader, String dbName) {
        if (this.leaderInfo.term() < newLeader.term() && newLeader.memberId() != null) {
            this.leaderInfo = newLeader;
            this.sharedDiscoveryService.casLeaders(newLeader, this.localDBName);
        }
    }

    public void init() {
    }

    public void start() throws InterruptedException {
        this.coreTopology = this.sharedDiscoveryService.getCoreTopology(this);
        this.readReplicaTopology = this.sharedDiscoveryService.getReadReplicaTopology();
        this.sharedDiscoveryService.registerCoreMember(this);
        this.log.info("Registered core server %s", new Object[]{this.myself});
        this.sharedDiscoveryService.waitForClusterFormation();
        this.log.info("Cluster formed");
    }

    public void stop() {
        this.sharedDiscoveryService.unRegisterCoreMember(this);
        this.log.info("Unregistered core server %s", new Object[]{this.myself});
    }

    public void shutdown() {
    }

    public ReadReplicaTopology allReadReplicas() {
        return this.readReplicaTopology;
    }

    public ReadReplicaTopology localReadReplicas() {
        return this.allReadReplicas().filterTopologyByDb(this.localDBName);
    }

    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId upstream) {
        return this.localCoreServers().find(upstream).map(info -> Optional.of(info.getCatchupServer())).orElseGet(() -> this.readReplicaTopology.find(upstream).map(ReadReplicaInfo::getCatchupServer));
    }

    public CoreTopology allCoreServers() {
        return this.coreTopology;
    }

    public CoreTopology localCoreServers() {
        return this.allCoreServers().filterTopologyByDb(this.localDBName);
    }

    public void handleStepDown(long stepDownTerm, String dbName) {
        boolean wasLeaderForTerm;
        boolean bl = wasLeaderForTerm = Objects.equals(this.myself, this.leaderInfo.memberId()) && stepDownTerm == this.leaderInfo.term();
        if (wasLeaderForTerm) {
            this.log.info(String.format("Step down event detected. This topology member, with MemberId %s, was leader in term %s, now moving to follower.", this.myself, this.leaderInfo.term()));
            this.sharedDiscoveryService.casLeaders(this.leaderInfo.stepDown(), dbName);
        }
    }

    public String localDBName() {
        return this.localDBName;
    }

    public MemberId getMemberId() {
        return this.myself;
    }

    public CoreServerInfo getCoreServerInfo() {
        return this.coreServerInfo;
    }

    synchronized void onCoreTopologyChange(CoreTopology coreTopology) {
        this.log.info("Notified of core topology change " + coreTopology);
        this.coreTopology = coreTopology;
        this.listenerService.notifyListeners(coreTopology);
    }

    synchronized void onReadReplicaTopologyChange(ReadReplicaTopology readReplicaTopology) {
        this.log.info("Notified of read replica topology change " + readReplicaTopology);
        this.readReplicaTopology = readReplicaTopology;
    }

    private static CoreServerInfo extractCoreServerInfo(Config config) {
        AdvertisedSocketAddress raftAddress = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.raft_advertised_address);
        AdvertisedSocketAddress transactionSource = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address);
        ClientConnectorAddresses clientConnectorAddresses = ClientConnectorAddresses.extractFromConfig((Config)config);
        String dbName = (String)config.get(CausalClusteringSettings.database);
        return new CoreServerInfo(raftAddress, transactionSource, clientConnectorAddresses, dbName);
    }

    public boolean refusesToBeLeader() {
        return this.refusesToBeLeader;
    }

    public String toString() {
        return "SharedDiscoveryCoreClient{myself=" + this.myself + ", coreServerInfo=" + this.coreServerInfo + ", refusesToBeLeader=" + this.refusesToBeLeader + ", localDBName='" + this.localDBName + '\'' + ", leaderInfo=" + this.leaderInfo + ", coreTopology=" + this.coreTopology + '}';
    }
}

