/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery.procedures;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.TestTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.discovery.procedures.ClusterOverviewProcedure;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ClusterOverviewProcedureTest {
    @Test
    public void shouldProvideOverviewOfCoreServersAndReadReplicas() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        MemberId theLeader = new MemberId(UUID.randomUUID());
        MemberId follower1 = new MemberId(UUID.randomUUID());
        MemberId follower2 = new MemberId(UUID.randomUUID());
        coreMembers.put(theLeader, TestTopology.addressesForCore(0));
        coreMembers.put(follower1, TestTopology.addressesForCore(1));
        coreMembers.put(follower2, TestTopology.addressesForCore(2));
        HashMap<MemberId, ReadReplicaInfo> replicaMembers = new HashMap<MemberId, ReadReplicaInfo>();
        MemberId replica4 = new MemberId(UUID.randomUUID());
        MemberId replica5 = new MemberId(UUID.randomUUID());
        replicaMembers.put(replica4, TestTopology.addressesForReadReplica(4));
        replicaMembers.put(replica5, TestTopology.addressesForReadReplica(5));
        HashMap<MemberId, RoleInfo> roleMap = new HashMap<MemberId, RoleInfo>();
        roleMap.put(theLeader, RoleInfo.LEADER);
        roleMap.put(follower1, RoleInfo.FOLLOWER);
        roleMap.put(follower2, RoleInfo.FOLLOWER);
        Mockito.when((Object)topologyService.allCoreServers()).thenReturn((Object)new CoreTopology(null, false, coreMembers));
        Mockito.when((Object)topologyService.allReadReplicas()).thenReturn((Object)new ReadReplicaTopology(replicaMembers));
        Mockito.when((Object)topologyService.allCoreRoles()).thenReturn(roleMap);
        ClusterOverviewProcedure procedure = new ClusterOverviewProcedure((TopologyService)topologyService, (LogProvider)NullLogProvider.getInstance());
        RawIterator members = procedure.apply(null, new Object[0], null);
        MatcherAssert.assertThat((Object)members.next(), (Matcher)new IsRecord(theLeader.getUuid(), 5000, RoleInfo.LEADER, Iterators.asSet((Object[])new String[]{"core", "core0"})));
        MatcherAssert.assertThat((Object)members.next(), (Matcher)new IsRecord(follower1.getUuid(), 5001, RoleInfo.FOLLOWER, Iterators.asSet((Object[])new String[]{"core", "core1"})));
        MatcherAssert.assertThat((Object)members.next(), (Matcher)new IsRecord(follower2.getUuid(), 5002, RoleInfo.FOLLOWER, Iterators.asSet((Object[])new String[]{"core", "core2"})));
        MatcherAssert.assertThat((Object)members.next(), (Matcher)new IsRecord(replica4.getUuid(), 6004, RoleInfo.READ_REPLICA, Iterators.asSet((Object[])new String[]{"replica", "replica4"})));
        MatcherAssert.assertThat((Object)members.next(), (Matcher)new IsRecord(replica5.getUuid(), 6005, RoleInfo.READ_REPLICA, Iterators.asSet((Object[])new String[]{"replica", "replica5"})));
        Assert.assertFalse((boolean)members.hasNext());
    }

    class IsRecord
    extends TypeSafeMatcher<Object[]> {
        private final UUID memberId;
        private final int boltPort;
        private final RoleInfo role;
        private final Set<String> groups;
        private final String dbName;

        IsRecord(UUID memberId, int boltPort, RoleInfo role, Set<String> groups, String dbName) {
            this.memberId = memberId;
            this.boltPort = boltPort;
            this.role = role;
            this.groups = groups;
            this.dbName = dbName;
        }

        IsRecord(UUID memberId, int boltPort, RoleInfo role, Set<String> groups) {
            this.memberId = memberId;
            this.boltPort = boltPort;
            this.role = role;
            this.groups = groups;
            this.dbName = CausalClusteringSettings.database.getDefaultValue();
        }

        protected boolean matchesSafely(Object[] record) {
            if (record.length != 5) {
                return false;
            }
            if (!this.memberId.toString().equals(record[0])) {
                return false;
            }
            List<String> boltAddresses = Collections.singletonList("bolt://localhost:" + this.boltPort);
            if (!boltAddresses.equals(record[1])) {
                return false;
            }
            if (!this.role.name().equals(record[2])) {
                return false;
            }
            Set recordGroups = Iterables.asSet((Iterable)((List)record[3]));
            if (!this.groups.equals(recordGroups)) {
                return false;
            }
            return this.dbName.equals(record[4]);
        }

        public void describeTo(Description description) {
            description.appendText("memberId=" + this.memberId + ", boltPort=" + this.boltPort + ", role=" + this.role + ", groups=" + this.groups + ", database=" + this.dbName + '}');
        }
    }
}

