/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.helper.ErrorHandler;

public class ErrorHandlerTest {
    private static final String FAILMESSAGE = "More fail";

    @Test
    public void shouldExecuteAllFailingOperations() {
        AtomicBoolean bool = new AtomicBoolean(false);
        try {
            ErrorHandler.runAll((String)"test", (ErrorHandler.ThrowingRunnable[])new ErrorHandler.ThrowingRunnable[]{Assert::fail, () -> {
                bool.set(true);
                throw new IllegalStateException(FAILMESSAGE);
            }});
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"test", (Object)e.getMessage());
            Throwable cause = e.getCause();
            Assert.assertEquals(AssertionError.class, cause.getClass());
            Throwable[] suppressed = e.getSuppressed();
            Assert.assertEquals((long)1L, (long)suppressed.length);
            Assert.assertEquals(IllegalStateException.class, suppressed[0].getClass());
            Assert.assertEquals((Object)FAILMESSAGE, (Object)suppressed[0].getMessage());
            Assert.assertTrue((boolean)bool.get());
        }
    }
}

