/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.causalclustering.messaging.Channel;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ClientHandshakeException;
import org.neo4j.causalclustering.protocol.handshake.ClientMessage;
import org.neo4j.causalclustering.protocol.handshake.ClientMessageHandler;
import org.neo4j.causalclustering.protocol.handshake.HandshakeClient;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ProtocolStack;
import org.neo4j.causalclustering.protocol.handshake.StatusCode;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverResponse;
import org.neo4j.causalclustering.protocol.handshake.TestProtocols;

@RunWith(value=Parameterized.class)
public class HandshakeClientEnsureMagicTest {
    private CompletableFuture<ProtocolStack> protocolStackCompletableFuture;
    @Parameterized.Parameter
    public ClientMessage message;
    private Channel channel = (Channel)Mockito.mock(Channel.class);
    private ApplicationSupportedProtocols supportedApplicationProtocol = new ApplicationSupportedProtocols((Protocol.Category)Protocol.ApplicationProtocolCategory.RAFT, TestProtocols.TestApplicationProtocols.listVersionsOf(Protocol.ApplicationProtocolCategory.RAFT));
    private ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository((Protocol.ApplicationProtocol[])TestProtocols.TestApplicationProtocols.values(), this.supportedApplicationProtocol);
    private ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository((Protocol.ModifierProtocol[])TestProtocols.TestModifierProtocols.values(), Collections.emptyList());
    private HandshakeClient client = new HandshakeClient();

    @Parameterized.Parameters(name="{0}")
    public static Collection<ClientMessage> data() {
        return Arrays.asList(new ApplicationProtocolResponse(StatusCode.SUCCESS, "protocol", TestProtocols.TestApplicationProtocols.RAFT_1.implementation().intValue()), new ModifierProtocolResponse(StatusCode.SUCCESS, "modifier", TestProtocols.TestModifierProtocols.LZ4.implementation()), new SwitchOverResponse(StatusCode.SUCCESS));
    }

    @Before
    public void setUp() {
        this.protocolStackCompletableFuture = this.client.initiate(this.channel, this.applicationProtocolRepository, this.modifierProtocolRepository);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIfMagicHasNotBeenSent() {
        this.message.dispatch((ClientMessageHandler)this.client);
    }

    @Test(expected=ClientHandshakeException.class)
    public void shouldCompleteExceptionallyIfMagicHasNotBeenSent() throws Throwable {
        try {
            this.message.dispatch((ClientMessageHandler)this.client);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.protocolStackCompletableFuture.getNow(null);
        }
        catch (CompletionException ex) {
            throw ex.getCause();
        }
    }

    @Test
    public void shouldNotThrowIfMagicHasBeenSent() {
        InitialMagicMessage.instance().dispatch((ClientMessageHandler)this.client);
        this.message.dispatch((ClientMessageHandler)this.client);
    }

    @Test
    public void shouldNotCompleteExceptionallyIfMagicHasBeenSent() {
        InitialMagicMessage.instance().dispatch((ClientMessageHandler)this.client);
        this.message.dispatch((ClientMessageHandler)this.client);
        try {
            this.protocolStackCompletableFuture.getNow(null);
        }
        catch (CompletionException ex) {
            Assert.assertThat((Object)ex.getMessage().toLowerCase(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"magic")));
        }
    }
}

