/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.filters;

import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.routing.load_balancing.filters.MinimumCountFilter;
import org.neo4j.helpers.collection.Iterators;

public class MinimumCountFilterTest {
    @Test
    public void shouldFilterBelowCount() {
        MinimumCountFilter minFilter = new MinimumCountFilter(3);
        Set input = Iterators.asSet((Object[])new Integer[]{1, 2});
        Set output = minFilter.apply(input);
        Assert.assertEquals(Collections.emptySet(), (Object)output);
    }

    @Test
    public void shouldPassAtCount() {
        MinimumCountFilter minFilter = new MinimumCountFilter(3);
        Set input = Iterators.asSet((Object[])new Integer[]{1, 2, 3});
        Set output = minFilter.apply(input);
        Assert.assertEquals((Object)input, (Object)output);
    }

    @Test
    public void shouldPassAboveCount() {
        MinimumCountFilter minFilter = new MinimumCountFilter(3);
        Set input = Iterators.asSet((Object[])new Integer[]{1, 2, 3, 4});
        Set output = minFilter.apply(input);
        Assert.assertEquals((Object)input, (Object)output);
    }
}

