/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.causalclustering.routing.load_balancing.filters.Filter;
import org.neo4j.causalclustering.routing.load_balancing.filters.FilterChain;
import org.neo4j.causalclustering.routing.load_balancing.filters.FirstValidRule;
import org.neo4j.causalclustering.routing.load_balancing.filters.IdentityFilter;
import org.neo4j.causalclustering.routing.load_balancing.filters.MinimumCountFilter;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.AnyGroupFilter;
import org.neo4j.causalclustering.routing.load_balancing.plugins.server_policies.ServerInfo;

class FilterBuilder {
    private List<Filter<ServerInfo>> current = new ArrayList<Filter<ServerInfo>>();
    private List<FilterChain<ServerInfo>> rules = new ArrayList<FilterChain<ServerInfo>>();

    FilterBuilder() {
    }

    static FilterBuilder filter() {
        return new FilterBuilder();
    }

    FilterBuilder min(int minCount) {
        this.current.add((Filter<ServerInfo>)new MinimumCountFilter(minCount));
        return this;
    }

    FilterBuilder groups(String ... groups) {
        this.current.add((Filter<ServerInfo>)new AnyGroupFilter(groups));
        return this;
    }

    FilterBuilder all() {
        this.current.add((Filter<ServerInfo>)IdentityFilter.as());
        return this;
    }

    FilterBuilder newRule() {
        if (!this.current.isEmpty()) {
            this.rules.add((FilterChain<ServerInfo>)new FilterChain(this.current));
            this.current = new ArrayList<Filter<ServerInfo>>();
        }
        return this;
    }

    Filter<ServerInfo> build() {
        this.newRule();
        return new FirstValidRule(this.rules);
    }
}

