/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing.procedure;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.TestTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.routing.Role;
import org.neo4j.causalclustering.routing.load_balancing.procedure.LegacyGetServersProcedure;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=Parameterized.class)
public class GetServersProcedureV1Test {
    private final ClusterId clusterId = new ClusterId(UUID.randomUUID());
    @Parameterized.Parameter(value=0)
    public String description;
    @Parameterized.Parameter(value=1)
    public Config config;
    @Parameterized.Parameter(value=2)
    public boolean expectFollowersAsReadEndPoints;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"with followers as read end points", Config.defaults((Setting)CausalClusteringSettings.cluster_allow_reads_on_followers, (String)"true"), true}, {"no followers as read end points", Config.defaults((Setting)CausalClusteringSettings.cluster_allow_reads_on_followers, (String)"false"), false});
    }

    @Test
    public void ttlShouldBeInSeconds() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, new HashMap());
        Mockito.when((Object)coreTopologyService.localCoreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.localReadReplicas()).thenReturn((Object)new ReadReplicaTopology(Collections.emptyMap()));
        this.config.augment(CausalClusteringSettings.cluster_routing_ttl, "10m");
        LegacyGetServersProcedure proc = new LegacyGetServersProcedure((TopologyService)coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        List results = Iterators.asList((RawIterator)proc.apply(null, new Object[0], null));
        Object[] rows = (Object[])results.get(0);
        long ttlInSeconds = (Long)rows[0];
        Assert.assertEquals((long)600L, (long)ttlInSeconds);
    }

    @Test
    public void shouldHaveCorrectSignature() {
        LegacyGetServersProcedure proc = new LegacyGetServersProcedure(null, null, this.config, (LogProvider)NullLogProvider.getInstance());
        ProcedureSignature signature = proc.signature();
        MatcherAssert.assertThat((Object)signature.outputSignature(), (Matcher)Matchers.containsInAnyOrder((Object[])new FieldSignature[]{FieldSignature.outputField((String)"ttl", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger), FieldSignature.outputField((String)"servers", (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap))}));
    }

    @Test
    public void shouldProvideReaderAndRouterForSingleCoreSetup() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        coreMembers.put(RaftTestMember.member(0), TestTopology.addressesForCore(0));
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, coreMembers);
        Mockito.when((Object)coreTopologyService.localCoreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.localReadReplicas()).thenReturn((Object)new ReadReplicaTopology(Collections.emptyMap()));
        LegacyGetServersProcedure proc = new LegacyGetServersProcedure((TopologyService)coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(proc);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.readAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        builder.routeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnCoreServersWithRouteAllCoresButLeaderAsReadAndSingleWriteActions() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)RaftTestMember.member(0));
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        coreMembers.put(RaftTestMember.member(0), TestTopology.addressesForCore(0));
        coreMembers.put(RaftTestMember.member(1), TestTopology.addressesForCore(1));
        coreMembers.put(RaftTestMember.member(2), TestTopology.addressesForCore(2));
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, coreMembers);
        Mockito.when((Object)coreTopologyService.localCoreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.localReadReplicas()).thenReturn((Object)new ReadReplicaTopology(Collections.emptyMap()));
        LegacyGetServersProcedure proc = new LegacyGetServersProcedure((TopologyService)coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(proc);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.writeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        builder.readAddress(TestTopology.addressesForCore(1).connectors().boltAddress());
        builder.readAddress(TestTopology.addressesForCore(2).connectors().boltAddress());
        builder.routeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        builder.routeAddress(TestTopology.addressesForCore(1).connectors().boltAddress());
        builder.routeAddress(TestTopology.addressesForCore(2).connectors().boltAddress());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnSelfIfOnlyMemberOfTheCluster() throws Exception {
        CoreTopologyService coreTopologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)RaftTestMember.member(0));
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        coreMembers.put(RaftTestMember.member(0), TestTopology.addressesForCore(0));
        CoreTopology clusterTopology = new CoreTopology(this.clusterId, false, coreMembers);
        Mockito.when((Object)coreTopologyService.localCoreServers()).thenReturn((Object)clusterTopology);
        Mockito.when((Object)coreTopologyService.localReadReplicas()).thenReturn((Object)new ReadReplicaTopology(Collections.emptyMap()));
        LegacyGetServersProcedure proc = new LegacyGetServersProcedure((TopologyService)coreTopologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(proc);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.writeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        builder.readAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        builder.routeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnTheCoreLeaderForWriteAndReadReplicasAndCoresForReads() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        MemberId theLeader = RaftTestMember.member(0);
        coreMembers.put(theLeader, TestTopology.addressesForCore(0));
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)new CoreTopology(this.clusterId, false, coreMembers));
        Mockito.when((Object)topologyService.localReadReplicas()).thenReturn((Object)new ReadReplicaTopology(TestTopology.readReplicaInfoMap(1)));
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)theLeader);
        LegacyGetServersProcedure procedure = new LegacyGetServersProcedure((TopologyService)topologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(procedure);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.writeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        if (this.expectFollowersAsReadEndPoints) {
            builder.readAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        }
        builder.readAddress(TestTopology.addressesForReadReplica(1).connectors().boltAddress());
        builder.routeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnCoreMemberAsReadServerIfNoReadReplicasAvailable() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        MemberId theLeader = RaftTestMember.member(0);
        coreMembers.put(theLeader, TestTopology.addressesForCore(0));
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)new CoreTopology(this.clusterId, false, coreMembers));
        Mockito.when((Object)topologyService.localReadReplicas()).thenReturn((Object)new ReadReplicaTopology(Collections.emptyMap()));
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)theLeader);
        LegacyGetServersProcedure procedure = new LegacyGetServersProcedure((TopologyService)topologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(procedure);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.writeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        builder.readAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        builder.routeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnNoWriteEndpointsIfThereIsNoLeader() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        coreMembers.put(RaftTestMember.member(0), TestTopology.addressesForCore(0));
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)new CoreTopology(this.clusterId, false, coreMembers));
        Mockito.when((Object)topologyService.localReadReplicas()).thenReturn((Object)new ReadReplicaTopology(Collections.emptyMap()));
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenThrow(new Throwable[]{new NoLeaderFoundException()});
        LegacyGetServersProcedure procedure = new LegacyGetServersProcedure((TopologyService)topologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(procedure);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.readAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        builder.routeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    @Test
    public void shouldReturnNoWriteEndpointsIfThereIsNoAddressForTheLeader() throws Exception {
        CoreTopologyService topologyService = (CoreTopologyService)Mockito.mock(CoreTopologyService.class);
        HashMap<MemberId, CoreServerInfo> coreMembers = new HashMap<MemberId, CoreServerInfo>();
        coreMembers.put(RaftTestMember.member(0), TestTopology.addressesForCore(0));
        Mockito.when((Object)topologyService.localCoreServers()).thenReturn((Object)new CoreTopology(this.clusterId, false, coreMembers));
        Mockito.when((Object)topologyService.localReadReplicas()).thenReturn((Object)new ReadReplicaTopology(Collections.emptyMap()));
        LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
        Mockito.when((Object)leaderLocator.getLeader()).thenReturn((Object)RaftTestMember.member(1));
        LegacyGetServersProcedure procedure = new LegacyGetServersProcedure((TopologyService)topologyService, leaderLocator, this.config, (LogProvider)NullLogProvider.getInstance());
        ClusterView clusterView = this.run(procedure);
        ClusterView.Builder builder = new ClusterView.Builder();
        builder.readAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        builder.routeAddress(TestTopology.addressesForCore(0).connectors().boltAddress());
        Assert.assertEquals((Object)builder.build(), (Object)clusterView);
    }

    private ClusterView run(LegacyGetServersProcedure proc) throws ProcedureException {
        Object[] rows = (Object[])Iterators.asList((RawIterator)proc.apply(null, new Object[0], null)).get(0);
        Assert.assertEquals((long)((Duration)this.config.get(CausalClusteringSettings.cluster_routing_ttl)).getSeconds(), (long)((Long)rows[0]));
        return ClusterView.parse((List)rows[1]);
    }

    private static class ClusterView {
        private final Map<Role, Set<AdvertisedSocketAddress>> clusterView;

        private ClusterView(Map<Role, Set<AdvertisedSocketAddress>> clusterView) {
            this.clusterView = clusterView;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterView that = (ClusterView)o;
            return Objects.equals(this.clusterView, that.clusterView);
        }

        public int hashCode() {
            return Objects.hash(this.clusterView);
        }

        public String toString() {
            return "ClusterView{clusterView=" + this.clusterView + '}';
        }

        static ClusterView parse(List<Map<String, Object>> result) {
            HashMap<Role, Set<AdvertisedSocketAddress>> view = new HashMap<Role, Set<AdvertisedSocketAddress>>();
            for (Map<String, Object> single : result) {
                Role role = Role.valueOf((String)((String)single.get("role")));
                Set<AdvertisedSocketAddress> addresses = ClusterView.parse((Object[])single.get("addresses"));
                Assert.assertFalse((boolean)view.containsKey(role));
                view.put(role, addresses);
            }
            return new ClusterView(view);
        }

        private static Set<AdvertisedSocketAddress> parse(Object[] addresses) {
            List list = Stream.of(addresses).map(address -> ClusterView.parse((String)address)).collect(Collectors.toList());
            HashSet<AdvertisedSocketAddress> set = new HashSet<AdvertisedSocketAddress>(list);
            Assert.assertEquals((long)list.size(), (long)set.size());
            return set;
        }

        private static AdvertisedSocketAddress parse(String address) {
            String[] split = address.split(":");
            Assert.assertEquals((long)2L, (long)split.length);
            return new AdvertisedSocketAddress(split[0], Integer.valueOf(split[1]).intValue());
        }

        static class Builder {
            private final Map<Role, Set<AdvertisedSocketAddress>> view = new HashMap<Role, Set<AdvertisedSocketAddress>>();

            Builder() {
            }

            Builder readAddress(AdvertisedSocketAddress address) {
                this.addAddress(Role.READ, address);
                return this;
            }

            Builder writeAddress(AdvertisedSocketAddress address) {
                this.addAddress(Role.WRITE, address);
                return this;
            }

            Builder routeAddress(AdvertisedSocketAddress address) {
                this.addAddress(Role.ROUTE, address);
                return this;
            }

            private void addAddress(Role role, AdvertisedSocketAddress address) {
                Set advertisedSocketAddresses = this.view.computeIfAbsent(role, k -> new HashSet());
                advertisedSocketAddresses.add(address);
            }

            public ClusterView build() {
                return new ClusterView(this.view);
            }
        }
    }
}

