/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import java.net.URI;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.scenarios.DiscoveryServiceType;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.causalclustering.ClusterRule;

@RunWith(value=Parameterized.class)
public class ClusterOverviewIT {
    @Rule
    public ClusterRule clusterRule = new ClusterRule().withSharedCoreParam(CausalClusteringSettings.cluster_topology_refresh, "5s");

    @Parameterized.Parameters(name="discovery-{0}")
    public static Collection<DiscoveryServiceType> data() {
        return Arrays.asList(DiscoveryServiceType.values());
    }

    public ClusterOverviewIT(DiscoveryServiceType discoveryServiceType) {
        this.clusterRule.withDiscoveryServiceType(discoveryServiceType);
    }

    @Test
    public void shouldDiscoverCoreMembers() throws Exception {
        int coreMembers = 3;
        this.clusterRule.withNumberOfCoreMembers(coreMembers);
        this.clusterRule.withNumberOfReadReplicas(0);
        Cluster cluster = this.clusterRule.startCluster();
        Matcher expected = Matchers.allOf(this.containsMemberAddresses(cluster.coreMembers()), this.containsRole(RoleInfo.LEADER, 1L), this.containsRole(RoleInfo.FOLLOWER, coreMembers - 1), this.doesNotContainRole(RoleInfo.READ_REPLICA));
        this.assertAllEventualOverviews(cluster, (Matcher<List<MemberInfo>>)expected);
    }

    @Test
    public void shouldDiscoverCoreMembersAndReadReplicas() throws Exception {
        int coreMembers = 3;
        this.clusterRule.withNumberOfCoreMembers(coreMembers);
        int replicaCount = 3;
        this.clusterRule.withNumberOfReadReplicas(replicaCount);
        Cluster cluster = this.clusterRule.startCluster();
        Matcher expected = Matchers.allOf(this.containsAllMemberAddresses(cluster.coreMembers(), cluster.readReplicas()), this.containsRole(RoleInfo.LEADER, 1L), this.containsRole(RoleInfo.FOLLOWER, 2L), this.containsRole(RoleInfo.READ_REPLICA, replicaCount));
        this.assertAllEventualOverviews(cluster, (Matcher<List<MemberInfo>>)expected);
    }

    @Test
    public void shouldDiscoverReadReplicasAfterRestartingCores() throws Exception {
        int coreMembers = 3;
        int readReplicas = 3;
        this.clusterRule.withNumberOfCoreMembers(coreMembers);
        this.clusterRule.withNumberOfReadReplicas(readReplicas);
        Cluster cluster = this.clusterRule.startCluster();
        cluster.shutdownCoreMembers();
        cluster.startCoreMembers();
        Matcher expected = Matchers.allOf(this.containsAllMemberAddresses(cluster.coreMembers(), cluster.readReplicas()), this.containsRole(RoleInfo.LEADER, 1L), this.containsRole(RoleInfo.FOLLOWER, coreMembers - 1), this.containsRole(RoleInfo.READ_REPLICA, readReplicas));
        this.assertAllEventualOverviews(cluster, (Matcher<List<MemberInfo>>)expected);
    }

    @Test
    public void shouldDiscoverNewCoreMembers() throws Exception {
        int initialCoreMembers = 3;
        this.clusterRule.withNumberOfCoreMembers(initialCoreMembers);
        this.clusterRule.withNumberOfReadReplicas(0);
        Cluster cluster = this.clusterRule.startCluster();
        int extraCoreMembers = 2;
        int finalCoreMembers = initialCoreMembers + extraCoreMembers;
        IntStream.range(0, extraCoreMembers).forEach(idx -> cluster.addCoreMemberWithId(initialCoreMembers + idx).start());
        Matcher expected = Matchers.allOf(this.containsMemberAddresses(cluster.coreMembers()), this.containsRole(RoleInfo.LEADER, 1L), this.containsRole(RoleInfo.FOLLOWER, finalCoreMembers - 1));
        this.assertAllEventualOverviews(cluster, (Matcher<List<MemberInfo>>)expected);
    }

    @Test
    public void shouldDiscoverNewReadReplicas() throws Exception {
        int coreMembers = 3;
        int initialReadReplicas = 3;
        this.clusterRule.withNumberOfCoreMembers(coreMembers);
        this.clusterRule.withNumberOfReadReplicas(initialReadReplicas);
        Cluster cluster = this.clusterRule.startCluster();
        cluster.addReadReplicaWithId(3).start();
        cluster.addReadReplicaWithId(4).start();
        Matcher expected = Matchers.allOf(this.containsAllMemberAddresses(cluster.coreMembers(), cluster.readReplicas()), this.containsRole(RoleInfo.LEADER, 1L), this.containsRole(RoleInfo.FOLLOWER, coreMembers - 1), this.containsRole(RoleInfo.READ_REPLICA, initialReadReplicas + 2));
        this.assertAllEventualOverviews(cluster, (Matcher<List<MemberInfo>>)expected);
    }

    @Test
    public void shouldDiscoverRemovalOfReadReplicas() throws Exception {
        int coreMembers = 3;
        int initialReadReplicas = 3;
        this.clusterRule.withNumberOfCoreMembers(coreMembers);
        this.clusterRule.withNumberOfReadReplicas(initialReadReplicas);
        Cluster cluster = this.clusterRule.startCluster();
        this.assertAllEventualOverviews(cluster, this.containsRole(RoleInfo.READ_REPLICA, initialReadReplicas));
        cluster.removeReadReplicaWithMemberId(0);
        cluster.removeReadReplicaWithMemberId(1);
        this.assertAllEventualOverviews(cluster, this.containsRole(RoleInfo.READ_REPLICA, initialReadReplicas - 2));
    }

    @Test
    public void shouldDiscoverRemovalOfCoreMembers() throws Exception {
        int coreMembers = 5;
        this.clusterRule.withNumberOfCoreMembers(coreMembers);
        this.clusterRule.withNumberOfReadReplicas(0);
        Cluster cluster = this.clusterRule.startCluster();
        this.assertAllEventualOverviews(cluster, (Matcher<List<MemberInfo>>)Matchers.allOf(this.containsRole(RoleInfo.LEADER, 1L), this.containsRole(RoleInfo.FOLLOWER, coreMembers - 1)));
        cluster.removeCoreMemberWithServerId(0);
        cluster.removeCoreMemberWithServerId(1);
        this.assertAllEventualOverviews(cluster, (Matcher<List<MemberInfo>>)Matchers.allOf(this.containsRole(RoleInfo.LEADER, 1L), this.containsRole(RoleInfo.FOLLOWER, coreMembers - 1 - 2)), Iterators.asSet((Object[])new Integer[]{0, 1}), Collections.emptySet());
    }

    @Test
    public void shouldDiscoverTimeoutBasedLeaderStepdown() throws Exception {
        this.clusterRule.withNumberOfCoreMembers(3);
        this.clusterRule.withNumberOfReadReplicas(2);
        Cluster cluster = this.clusterRule.startCluster();
        List<CoreClusterMember> followers = cluster.getAllMembersWithRole(Role.FOLLOWER);
        CoreClusterMember leader = cluster.getMemberWithRole(Role.LEADER);
        followers.forEach(CoreClusterMember::shutdown);
        this.assertEventualOverview(this.containsRole(RoleInfo.LEADER, 0L), leader, "core");
    }

    @Test
    public void shouldDiscoverGreaterTermBasedLeaderStepdown() throws Exception {
        int originalCoreMembers = 3;
        this.clusterRule.withNumberOfCoreMembers(originalCoreMembers);
        Cluster cluster = this.clusterRule.startCluster();
        CoreClusterMember leader = cluster.awaitLeader();
        leader.config().augment(CausalClusteringSettings.refuse_to_be_leader, "true");
        List<MemberInfo> preElectionOverview = this.clusterOverview((GraphDatabaseFacade)leader.database());
        CoreClusterMember follower = cluster.getMemberWithRole(Role.FOLLOWER);
        follower.raft().triggerElection(Clock.systemUTC());
        this.assertEventualOverview((Matcher<List<MemberInfo>>)Matchers.allOf(this.containsRole(RoleInfo.LEADER, 1L), this.containsRole(RoleInfo.FOLLOWER, originalCoreMembers - 1), (Matcher)Matchers.not((Matcher)Matchers.equalTo(preElectionOverview))), leader, "core");
    }

    private void assertAllEventualOverviews(Cluster cluster, Matcher<List<MemberInfo>> expected) throws KernelException, InterruptedException {
        this.assertAllEventualOverviews(cluster, expected, Collections.emptySet(), Collections.emptySet());
    }

    private void assertAllEventualOverviews(Cluster cluster, Matcher<List<MemberInfo>> expected, Set<Integer> excludedCores, Set<Integer> excludedRRs) throws KernelException, InterruptedException {
        for (CoreClusterMember core : cluster.coreMembers()) {
            if (excludedCores.contains(core.serverId())) continue;
            this.assertEventualOverview(expected, core, "core");
        }
        for (ReadReplica rr : cluster.readReplicas()) {
            if (excludedRRs.contains(rr.serverId())) continue;
            this.assertEventualOverview(expected, rr, "rr");
        }
    }

    private void assertEventualOverview(Matcher<List<MemberInfo>> expected, ClusterMember<? extends GraphDatabaseFacade> member, String role) throws KernelException, InterruptedException {
        Function<List, String> printableMemberInfos = memberInfos -> memberInfos.stream().map(MemberInfo::toString).collect(Collectors.joining(", "));
        String message = String.format("should have overview from %s %s, but view was ", role, member.serverId());
        Assert.assertEventually(memberInfos -> message + (String)printableMemberInfos.apply((List)memberInfos), () -> this.clusterOverview((GraphDatabaseFacade)member.database()), expected, (long)90L, (TimeUnit)TimeUnit.SECONDS);
    }

    @SafeVarargs
    private final Matcher<Iterable<? extends MemberInfo>> containsAllMemberAddresses(Collection<? extends ClusterMember> ... members) {
        return this.containsMemberAddresses(Stream.of(members).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private Matcher<Iterable<? extends MemberInfo>> containsMemberAddresses(Collection<? extends ClusterMember> members) {
        return Matchers.containsInAnyOrder((Collection)members.stream().map(coreClusterMember -> new TypeSafeMatcher<MemberInfo>(){

            protected boolean matchesSafely(MemberInfo item) {
                Set addresses = Iterators.asSet((Object[])item.addresses);
                for (URI uri : coreClusterMember.clientConnectorAddresses().uriList()) {
                    if (addresses.contains(uri.toString())) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("MemberInfo with addresses: ").appendValue((Object)coreClusterMember.clientConnectorAddresses().boltAddress());
            }
        }).collect(Collectors.toList()));
    }

    private Matcher<List<MemberInfo>> containsRole(final RoleInfo expectedRole, long expectedCount) {
        return new FeatureMatcher<List<MemberInfo>, Long>(Matchers.equalTo((Object)expectedCount), expectedRole.name(), "count"){

            protected Long featureValueOf(List<MemberInfo> overview) {
                return overview.stream().filter(info -> ((MemberInfo)info).role == expectedRole).count();
            }
        };
    }

    private Matcher<List<MemberInfo>> doesNotContainRole(RoleInfo unexpectedRole) {
        return this.containsRole(unexpectedRole, 0L);
    }

    /*
     * Exception decompiling
     */
    private List<MemberInfo> clusterOverview(GraphDatabaseFacade db) throws TransactionFailureException, ProcedureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class MemberInfo {
        private final String[] addresses;
        private final RoleInfo role;

        MemberInfo(String[] addresses, RoleInfo role) {
            this.addresses = addresses;
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberInfo that = (MemberInfo)o;
            return Arrays.equals(this.addresses, that.addresses) && this.role == that.role;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.addresses), this.role);
        }

        public String toString() {
            return String.format("MemberInfo{addresses='%s', role=%s}", Arrays.toString(this.addresses), this.role);
        }
    }
}

