/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.scenarios;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.causalclustering.ClusterRule;

public class UnavailableIT {
    @Rule
    public final ClusterRule clusterRule = new ClusterRule().withNumberOfCoreMembers(3);
    private Cluster cluster;

    @Before
    public void setup() throws Exception {
        this.cluster = this.clusterRule.startCluster();
    }

    @Test
    public void shouldReturnUnavailableStatusWhenDoingLongOperation() {
        CoreClusterMember member = this.cluster.getCoreMemberById(1);
        ((AvailabilityGuard)member.database().getDependencyResolver().resolveDependency(AvailabilityGuard.class)).require(() -> "Not doing long operation");
        try (Transaction tx = member.database().beginTx();){
            tx.success();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)Status.General.DatabaseUnavailable, (Object)Status.statusCodeOf((Throwable)e));
        }
    }

    @Test
    public void shouldReturnUnavailableStatusWhenShutdown() {
        CoreClusterMember member = this.cluster.getCoreMemberById(1);
        Object db = member.database();
        member.shutdown();
        try (Transaction tx = db.beginTx();){
            tx.success();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)Status.General.DatabaseUnavailable, (Object)Status.statusCodeOf((Throwable)e));
        }
    }
}

